package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.model.HistoryArriveRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.List;

public class HistoryArriveRecordWriter extends InsertOrUpdateItemWriter<HistoryArriveRecord> {
	private Logger logger = LoggerFactory.getLogger(HistoryArriveRecordWriter.class);

	private final static String SQL_INSERT = "INSERT INTO d_history_arrive_record (person_unid,countdate,history_arrive_person_unid,history_arrive_date,mall_id,account_id) "
			+ "VALUES (:personUnid, :countdate, :historyArrivePersonUnid,:historyArriveDate,:mallId,:accountId);";
	public HistoryArriveRecordWriter(DataSource dataSource) {
		super(SQL_INSERT, null, dataSource);
	}

	@Override
	public void write(List items) throws Exception {
		if (items.isEmpty()) {
			return;
		}
		logger.error("新老顾客Writer接收到：{}条数据进行插入操作",items.size());
		List<HistoryArriveRecord>  historyArriveRecords = new ArrayList<>();
		items.stream().filter(item ->((FaceRecognition)item).getHistoryArrivalRecords() != null).
                forEach(item ->historyArriveRecords.addAll(((FaceRecognition)item).getHistoryArrivalRecords()));
		if(historyArriveRecords == null || historyArriveRecords.size() <= 0){
			return;
		}
		super.write(historyArriveRecords);
	}
	@Override
	protected boolean needInsert(HistoryArriveRecord item) {
		return true;//都是需要插入的数据
	}
}
