package com.viontech.keliu;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableAutoConfiguration
@EnableTransactionManagement
@EnableBatchProcessing
@EnableScheduling
@ComponentScan(basePackages ={"com.viontech.*"},
		excludeFilters = {
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = com.viontech.keliu.runner.JobStartRunner.class),
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = com.viontech.keliu.runner.WorkQueueProcessRunner.class),
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = com.viontech.keliu.runner.ResidenceRunner.class),
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = com.viontech.keliu.jobhandler.DeviceUpdateJob.class),
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = com.viontech.keliu.jobhandler.CountDataRedis2DBHandler.class),
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = com.viontech.keliu.jobhandler.FaceDataSta2DBProcessHandler.class),
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = com.viontech.keliu.jobhandler.TodayTrackProcessJob.class)
})
public class Application {

	private static Logger logger = LoggerFactory.getLogger(Application.class);

	public static void main(String[] args) {
		try {
			SpringApplication.run(Application.class, args);
		} catch (Exception e) {
			logger.error("程序启动失败",e);
			e.printStackTrace();
		}
	}

	@Bean
	public TaskExecutor taskExecutor(){
		ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
		threadPoolTaskExecutor.setMaxPoolSize(50);
		threadPoolTaskExecutor.setCorePoolSize(20);
		return threadPoolTaskExecutor;
	}
}