package com.viontech.keliu.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.*;
import java.util.*;


public class SerialNumberUtil {
	private static Logger logger = LoggerFactory.getLogger(SerialNumberUtil.class);
	public final static String CPU_ID = "cpuId";
	public final static String DISK_ID = "diskId";
	public final static String MAINBOARD_ID = "mainboardId";
	public final static String LICENSE_DATE = "licenseDate";
	/**
	 * 获取主板序列号
	 * wmic csproduct get UUID
	 * @return
	 */
	public static String getMotherboardSN() {
		String result = "";
		try {
			long start = System.currentTimeMillis();
			Process process = Runtime.getRuntime().exec(
					new String[] { "wmic", "csproduct", "get", "UUID" });
			process.getOutputStream().close();
			Scanner sc = new Scanner(process.getInputStream());
			String property = sc.next();
			result = sc.next();
		} catch (Exception e) {
			e.fillInStackTrace();
		}
		if (result.trim().length() < 1 || result == null) {
			result = "无CPU_ID被读取";
		}
		return result.trim();
	}

	/**
	 * 获取硬盘序列号(该方法获取的是 盘符的逻辑序列号,并不是硬盘本身的序列号)
	 * 硬盘序列号还在研究中
	 * @param drive 盘符
	 * @return
	 */
	public static String getHardDiskSN(String drive) {
		String result = "";
		try {
			File file = File.createTempFile("realhowto", ".vbs");
			file.deleteOnExit();
			FileWriter fw = new FileWriter(file);

			String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\n"
					+ "Set colDrives = objFSO.Drives\n"
					+ "Set objDrive = colDrives.item(\""
					+ drive
					+ "\")\n"
					+ "Wscript.Echo objDrive.SerialNumber"; // see note
			fw.write(vbs);
			fw.close();
			String path = file.getPath().replace("%20", " ");
			Process p = Runtime.getRuntime().exec(
					"cscript //NoLogo " + path);
			BufferedReader input = new BufferedReader(new InputStreamReader(
					p.getInputStream()));
			String line;
			while ((line = input.readLine()) != null) {
				result += line;
			}
			input.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result.trim();
	}

	/**
	 * 获取CPU序列号
	 * @return
	 */
	public static String getCPUSerial() {
		String result = "";
		try {
			long start = System.currentTimeMillis();
			Process process = Runtime.getRuntime().exec(
					new String[] { "wmic", "cpu", "get", "ProcessorId" });
			process.getOutputStream().close();
			Scanner sc = new Scanner(process.getInputStream());
			String property = sc.next();
			result = sc.next();
		} catch (Exception e) {
			e.fillInStackTrace();
		}
		if (result.trim().length() < 1 || result == null) {
			result = "无CPU_ID被读取";
		}
		return result.trim();
	}
	
	private static List<String> getLocalHostLANAddress()	throws UnknownHostException, SocketException {
		List<String> ips = new ArrayList<String>();
		Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
		while (interfs.hasMoreElements()) {
			NetworkInterface interf = interfs.nextElement();
			Enumeration<InetAddress> addres = interf.getInetAddresses();
			while (addres.hasMoreElements()) {
				InetAddress in = addres.nextElement();
				if (in instanceof Inet4Address) {
					System.out.println("v4:" + in.getHostAddress());
					if(!"127.0.0.1".equals(in.getHostAddress())){
						ips.add(in.getHostAddress());
					}
				}
			}
		}
		return ips;
	}
	
	/**
	 * MAC
	 * 通过jdk自带的方法,先获取本机所有的ip,然后通过NetworkInterface获取mac地址
	 * @return
	 */
	public static String getMac() {
		try {
			String resultStr = "";
			List<String> ls = getLocalHostLANAddress();
			for(String str : ls){
				InetAddress ia = InetAddress.getByName(str);// 获取本地IP对象
				// 获得网络接口对象（即网卡），并得到mac地址，mac地址存在于一个byte数组中。
				byte[] mac = NetworkInterface.getByInetAddress(ia)
						.getHardwareAddress();
				// 下面代码是把mac地址拼装成String
				StringBuilder sb = new StringBuilder();
				for (int i = 0; i < mac.length; i++) {
					if (i != 0) {
						sb.append("-");
					}
					// mac[i] & 0xFF 是为了把byte转化为正整数
					String s = Integer.toHexString(mac[i] & 0xFF);
					sb.append(s.length() == 1 ? 0 + s : s);
				}
				// 把字符串所有小写字母改为大写成为正规的mac地址并返回
				resultStr += sb.toString().toUpperCase()+",";
			}
			return resultStr;
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return null;
	}
	
	/***************************linux*********************************/
 
	public static String executeLinuxCmd(String cmd)  {
		try {
			System.out.println("got cmd job : " + cmd);
			Runtime run = Runtime.getRuntime();
			Process process;
			process = run.exec(cmd);
			InputStream in = process.getInputStream();
			BufferedReader bs = new BufferedReader(new InputStreamReader(in));
			StringBuffer out = new StringBuffer();
			byte[] b = new byte[8192];
			for (int n; (n = in.read(b)) != -1;) {
				out.append(new String(b, 0, n));
			}
			
			in.close();
			process.destroy();
			return out.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	/**
	 * 
	 * @param cmd 命令语句
	 * @param record 要查看的字段
	 * @param symbol 分隔符
	 * @return
	 */
	public static String getSerialNumber(String cmd ,String record,String symbol) {
		String execResult = executeLinuxCmd(cmd);
		String[] infos = execResult.split("\n");
		
		for(String info : infos) {
			info = info.trim();
			if(info.indexOf(record) != -1) {
				info = info.replace(" ", "");
				String[] sn = info.split(symbol);
				return sn[1];
			}
		}
		
		return null;
	}
	
	/**
	 * 获取CPUID、硬盘序列号、MAC地址、主板序列号
	 * @return
	 */
	public static Map<String, String> getAllSn(){
		String os = System.getProperty("os.name");
		os = os.toUpperCase();
		System.out.println(os);
		
		Map<String, String> snVo = new HashMap<String, String>();
		
		if("LINUX".equals(os)) {
			logger.info("=============>for linux");
			String cpuid = getSerialNumber("dmidecode -t processor | grep 'ID'", "ID",":");
			logger.info("cpuid : "+ cpuid);
			String mainboardNumber = 	getSerialNumber("dmidecode |grep 'Serial Number'", "Serial Number",":");
			logger.info("mainboardNumber : "+ mainboardNumber);
			String diskNumber = 		getSerialNumber("fdisk -l", "Disk identifier",":");
			logger.info("diskNumber : "+ diskNumber);
			//String mac = 				getSerialNumber("ifconfig -a", "ether"," ");
			
			snVo.put(CPU_ID,cpuid.toUpperCase().replace(" ", ""));
			snVo.put(DISK_ID,diskNumber.toUpperCase().replace(" ", ""));
			//snVo.put("mac",mac.toUpperCase().replace(" ", ""));
			snVo.put(MAINBOARD_ID,mainboardNumber.toUpperCase().replace(" ", ""));
		}else {
			logger.info("=============>for windows");
			String cpuid = SerialNumberUtil.getCPUSerial();
			String mainboard = SerialNumberUtil.getMotherboardSN();
			String disk = SerialNumberUtil.getHardDiskSN("c");
			//String mac = SerialNumberUtil.getMac();

			logger.info("CPU  SN:" + cpuid);
			logger.info("主板  SN:" + mainboard);
			logger.info("C盘   SN:" + disk);
			//System.out.println("MAC  SN:" + mac);
			
			snVo.put(CPU_ID,cpuid.toUpperCase().replace(" ", ""));
			snVo.put(DISK_ID,disk.toUpperCase().replace(" ", ""));
			//snVo.put("mac",mac.toUpperCase().replace(" ", ""));
			snVo.put(MAINBOARD_ID,mainboard.toUpperCase().replace(" ", ""));
		}
		
		return snVo;
	}
}
