package com.viontech.keliu.storage.convert;

import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * Created by 苏曼 on 2019/3/26.
 */
public class BufferedImageConvert implements Convert<BufferedImage> {

    @Override
    /**
     * 无损转化
     */
    public byte[] object2bytes(BufferedImage bufferedImage) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam param = imageWriter.getDefaultWriteParam();
            param.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
            param.setCompressionQuality(1.0F);
            try {
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(bufferedImage);

            } finally {
                imageWriter.dispose();
                imageOutputStream.flush();
            }
            return byteArrayOutputStream.toByteArray();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public BufferedImage bytes2Object(byte[] bytes) {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(bytes);    //将b作为输入流；
            BufferedImage image = ImageIO.read(in);
            return image;
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
