package com.viontech.keliu.storage;

import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.pathgenerator.PathStorage;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;

/**
 * @author 谢明辉
 * @createDate 2018-10-27
 * @description
 */

public class OssStorage<T> extends PathStorage<T> {
    private OssClientHelper ossClientHelper;

    @Override
    public void setItem(String key, T item) {
        ossClientHelper.storeFile(storagePathGenerator.generator(key), getConvert().object2bytes(item));
    }

    @Override
    public T getItem(String key) {
        try {
            return getConvert().bytes2Object(getByteArrayItem(key));
        } catch (Exception e) {

        }
        return null;
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return ossClientHelper.getByteArrayImage(storagePathGenerator.generator(key));
        } catch (Exception e) {

        }
        return null;
    }

    @Override
    public boolean isItemExist(String key) {
        return ossClientHelper.isExist(storagePathGenerator.generator(key));
    }


    public OssClientHelper getOssClientHelper() {
        return ossClientHelper;
    }

    public void setOssClientHelper(OssClientHelper ossClientHelper) {
        this.ossClientHelper = ossClientHelper;
    }

    @Override
    public boolean deleteItem(String key){
        return ossClientHelper.deleteItem(storagePathGenerator.generator(key));
    }

}
