package com.viontech.keliu.storage;

import com.viontech.keliu.storage.pathgenerator.PathStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;

/**
 * Created by 苏曼 on 2019/3/26.
 */
public class LocalStorage<T> extends PathStorage<T> {
    private Logger logger = LoggerFactory.getLogger(LocalStorage.class);
    private String basePath;
    @Override
    public void setItem(String key, T item) {
        OutputStream output = null;
        try {
            File file = new File(basePath,storagePathGenerator.generator(key));
            if(!file.getParentFile().exists()){
                file.getParentFile().mkdirs();
            }
            output = new FileOutputStream(file);
            output.write(getConvert().object2bytes(item));
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }finally{
            if(output != null){
                try {
                    output.flush();
                    output.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    @Override
    public T getItem(String key) {
        return getConvert().bytes2Object(getByteArrayItem(key));
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        File file = new File(basePath,storagePathGenerator.generator(key));
        try {
            return readFile(file);
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isItemExist(String key) {
        File file = new File(basePath,storagePathGenerator.generator(key));
        return file.exists();
    }

    protected byte[] readFile(File file) throws IOException {
        FileInputStream fi = null;
        try {
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                return null;
            }
            fi = new FileInputStream(file);
            byte[] buffer = new byte[(int) fileSize];
            int offset = 0;
            int numRead = 0;
            while (offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0) {
                offset += numRead;
            }
            // 确保所有数据均被读取
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            return buffer;
        } catch (Exception e){
            return null;
        }finally {
            if(fi != null) {
                fi.close();
            }
        }

    }

    public String getBasePath() {
        return basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public boolean deleteItem(String key){
        File file = new File(basePath,storagePathGenerator.generator(key));
        return file.delete();
    }

}
