package com.viontech.keliu.service;

import com.viontech.keliu.websocket.AlgApiClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

/**
 * @Author: 王洪波
 * @Date: 2019/3/7.
 * @Description:创建特征库线程锁
 */
@Service
public class CreateFeaturePoolService {
    public final Logger logger = LoggerFactory.getLogger(CreateFeaturePoolService.class);


    @Autowired(required = false)
    private AlgApiClient algApiClientComparison;

    public synchronized JSONObject createFeaturePool(String poolName){
            try {
                logger.info("准备创建："+poolName+" 池子");
                CompletableFuture<JSONObject> resultFuture = algApiClientComparison.addPersonPool(poolName, 2, new ArrayList<>(), new HashMap<>());
                JSONObject jsonObject = resultFuture.get(60, TimeUnit.SECONDS);
                logger.info("创建："+poolName+" 池子完成"+jsonObject.toString(2));
                return jsonObject;
            } catch (Exception e) {
                logger.info("创建："+poolName+" 池子失败");
                e.printStackTrace();
            }
            return null;

    }


}
