package com.viontech.keliu.processor.binary;

import com.viontech.keliu.content.Body;
import com.viontech.keliu.content.Content;
import com.viontech.keliu.content.Image;
import com.viontech.keliu.processor.VionMessageProcessor;
import com.viontech.keliu.util.YuvToRGB;
import io.netty.buffer.ByteBuf;

import java.awt.image.BufferedImage;

public abstract class VionBinaryMessageProcessor extends VionMessageProcessor{
	public Body parseBody(ByteBuf byteBuf){
		Body body;
		try {
			body = new Body();
			String msgId = readStr(byteBuf, 64);
			body.setMessageId(msgId);
			String command = readStr(byteBuf, 32);
			body.setCommand(command);
			String category = readStr(byteBuf, 32);
			body.setCategory(category);
			String contentName =readStr(byteBuf, 32);
			body.setContentName(contentName);
			String source = readStr(byteBuf, 32);
			body.setSource(source);
			String destination = readStr(byteBuf, 32);
			body.setDestination(destination);
			String reserved = readStr(byteBuf, 32);
			body.setReserved(reserved);
			Content content = parseContent(byteBuf);
			body.setContent(content);
			return body;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	public abstract Content parseContent(ByteBuf byteBuf);
	
	public abstract boolean buildContent(Content content,ByteBuf byteBuf);
	
	public String readStr(ByteBuf byteBuf,int length){
		String str = byteBuf.readCharSequence(length, charset).toString();
		return str.trim();
	} 
	
	@Override
	protected boolean buildByteBufBody(Body body, ByteBuf byteBuf) {
		try {
			byteBuf.writeBytes(transform(body.getMessageId(),64));
			byteBuf.writeBytes(transform(body.getCommand(),32));
			byteBuf.writeBytes(transform(getResponseCategory(),32));
			byteBuf.writeBytes(transform(body.getContentName(),32));
			byteBuf.writeBytes(transform(body.getSource(),32));
			byteBuf.writeBytes(transform(body.getDestination(),32));
			byteBuf.writeBytes(transform(body.getReserved(),32));
			boolean success = buildContent(body.getContent(), byteBuf);
			return success;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}
	
	
	@Override
	public boolean isValid(ByteBuf byteBuf) {

		long version = byteBuf.getUnsignedInt(8);
		long type = byteBuf.getUnsignedInt(12);
		if(type != MESSAGE_TYPE_BINARY){
			return false;
		}
		CharSequence command = byteBuf.getCharSequence(80, 32, charset);
		String commandStr = command.toString().trim();
		if(commandStr.equals(supportCommand()) && version == supportVersion()){
			return true;
		}
		return false;
	}

	protected Image parseYUV420Image(ByteBuf byteBuf){
		Image image = new Image();
		try {
			int version = byteBuf.readIntLE(); //int nVersion;
			image.setVersion(version);
		} catch (Exception e) {
			return null;
		}
		int type = byteBuf.readIntLE();//int nType;
		image.setType(type);
		int channels = byteBuf.readIntLE();//int nChannels;
		image.setChannels(channels);
		int depth = byteBuf.readIntLE();//int nDepth;
		image.setDepth(depth);
		int origin = byteBuf.readIntLE();//int nOrigin;
		image.setOrigin(origin);
		int width = byteBuf.readIntLE();//int nWidth;
		image.setWidth(width);
		int height = byteBuf.readIntLE();//int nHeight;
		image.setHeight(height);
		int imageSize = byteBuf.readIntLE();//int nImageSize;
		image.setImageSize(imageSize);
		int abandoned = byteBuf.readIntLE();//int abandoned;
		image.setAbandoned(abandoned);
		for (int j = 0; j < 4; j++) {//unsigned char * cImageData[4];/* pointers to aligned image data yuv */
			byteBuf.readIntLE();
		}
		for (int j = 0; j < 4; j++) {//int nWidthStep[4];
			byteBuf.readIntLE();
		}
		byteBuf.readIntLE();//void * pPrivate;

		int[] reserveds = new int[4];
		for (int j = 0; j < 4; j++) {//int reserved[4];
			int reserved = byteBuf.readIntLE();
			reserveds[j] = reserved;
		}
		image.setReserved(reserveds);
		//System.out.println(image);

		BufferedImage bi = null;
		if(type == 1) {
			byte[] y = new byte[width*height];
			byteBuf.readBytes(y);
			byte[] u = new byte[width*height/4];
			byteBuf.readBytes(u);
			byte[] v = new byte[width*height/4];
			byteBuf.readBytes(v);
			bi = YuvToRGB.Yuv420ToImage(y, u, v, width, height);
		}else if(type == 17){
			byte[] y = new byte[width*height];
			byteBuf.readBytes(y);
			byte[] u = new byte[width*height/2];
			byteBuf.readBytes(u);
			bi = YuvToRGB.Yuv420PSUVToImage(y,u,width,height);
		}
		image.setBufferedImage(bi);
		return image;
	}

	@Override
	public long supportType() {
		return MESSAGE_TYPE_BINARY;
	}
}
