package com.viontech.keliu.processor;


import com.viontech.keliu.content.Head;
import io.netty.buffer.ByteBuf;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public abstract class EarlierVionMessageProcessor extends VionMessageProcessor {

	protected Head parseHead(ByteBuf byteBuf) {
		try {
			Head head = new Head();
			long size = byteBuf.readUnsignedIntLE();
			head.setSize(size);
			long check = byteBuf.readUnsignedIntLE();
			head.setCheck(check);
			long version = byteBuf.readUnsignedInt();
			head.setVersion(version);
			long type = byteBuf.readUnsignedInt();
			head.setType(type);
			return head;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	public static String getCommandVersion(ByteBuf byteBuf){
		long size = byteBuf.getUnsignedIntLE(0);
		long version = byteBuf.getUnsignedInt(8);
		long type = byteBuf.getUnsignedInt(12);
		if(type == MESSAGE_TYPE_XML){
			Document doc = null;
			try {

				String xml = byteBuf.getCharSequence(16, (int)(size-16), charset).toString().trim();
				doc = DocumentHelper.parseText(xml); // 将字符串转为XML
				Element rootElt = doc.getRootElement(); // 获取根节点
				Element commandElement = rootElt.element(ELEMENT_NAME_COMMAND);
				String command = commandElement.getTextTrim();
				return command+"_"+type+"_"+version;
			}catch(Exception e){
				e.printStackTrace();
			}
		}else if(type == MESSAGE_TYPE_BINARY){
			CharSequence command = byteBuf.getCharSequence(80, 32, charset);
			String commandStr = command.toString().split("\0")[0].trim();
			return commandStr+"_"+type+"_"+version;
		}
		return null;

	}
}
