package com.viontech.keliu.model;

import java.util.Date;
import java.util.List;

/**
 * Created by 苏曼 on 2019/7/16.
 * 匹配参数类
 */
public class MatchParam {
    private List<Date> dates;

    private Long mallId;
    /**
     * 匹配门限值 超过该门限认为匹配成功
     */
    private int matchThreshold;
    /**
     * 追加特征门限值，如果匹配成功，且分数超过该门限我们认为该特征是他本人的，那么追加给他
     */
    private int appendThreshold;
    /**
     * 人脸质量分
     */
    private Float faceScore;
    /**
     * 人脸质量分门限
     */
    private Float faceScoerThreshold;
    /**
     * 是否追加，默认追加，店员库等手动维护库不应自动追加
     */
    private boolean append = true;
    /**
     * 是否开启分库，默认按照天分库，特殊需求可以不分库
     */
    private boolean subPool = false;

    private boolean matchBody = false;

    private boolean noPicture = false;

    private int matchBodyThreshold;

    private String[] personTypes;

    public List<Date> getDates() {
        return dates;
    }

    public void setDates(List<Date> dates) {
        this.dates = dates;
    }

    public Long getMallId() {
        return mallId;
    }

    public void setMallId(Long mallId) {
        this.mallId = mallId;
    }

    public int getMatchThreshold() {
        return matchThreshold;
    }

    public void setMatchThreshold(int matchThreshold) {
        this.matchThreshold = matchThreshold;
    }

    public int getAppendThreshold() {
        return appendThreshold;
    }

    public void setAppendThreshold(int appendThreshold) {
        this.appendThreshold = appendThreshold;
    }

    public Float getFaceScore() {
        return faceScore;
    }

    public void setFaceScore(Float faceScore) {
        this.faceScore = faceScore;
    }

    public Float getFaceScoerThreshold() {
        return faceScoerThreshold;
    }

    public void setFaceScoerThreshold(Float faceScoerThreshold) {
        this.faceScoerThreshold = faceScoerThreshold;
    }

    public boolean isAppend() {
        if (!append) {
            return false;
        }

        if (faceScore != null && faceScore < faceScoerThreshold) {
            return false;
        }
        return append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isSubPool() {
        return subPool;
    }

    public void setSubPool(boolean subPool) {
        this.subPool = subPool;
    }

    public boolean isMatchBody() {
        return matchBody;
    }

    public void setMatchBody(boolean matchBody) {
        this.matchBody = matchBody;
    }

    public int getMatchBodyThreshold() {
        return matchBodyThreshold;
    }

    public void setMatchBodyThreshold(int matchBodyThreshold) {
        this.matchBodyThreshold = matchBodyThreshold;
    }

    public String[] getPersonTypes() {
        return personTypes;
    }

    public void setPersonTypes(String[] personTypes) {
        this.personTypes = personTypes;
    }

    public boolean isNoPicture() {
        return noPicture;
    }

    public void setNoPicture(boolean noPicture) {
        this.noPicture = noPicture;
    }
}
