package com.viontech.keliu.content;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.viontech.keliu.util.DateUtil;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties({"countTime"})
public class TrackInfo implements Serializable{
	private String id;//人脸id or 抓拍id
	private String startTime;//轨迹起始时间
	private Date countTime;//统计时间
	private int trackLength;//轨迹长度，轨迹总帧数
	private int trackFrameRate;//轨迹视频的帧率
	private String fileName;//帧文件名称
	private List<Track> track;//轨迹信息
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
		try {
			this.setCountTime(DateUtil.parse(DateUtil.FORMAT_LONG, startTime));
		} catch (ParseException e) {
		}
	}

	public Date getCountTime() {
		return countTime;
	}

	public void setCountTime(Date countTime) {
		this.countTime = countTime;
	}

	public int getTrackLength() {
		return trackLength;
	}

	public void setTrackLength(int trackLength) {
		this.trackLength = trackLength;
	}

	public int getTrackFrameRate() {
		return trackFrameRate;
	}

	public void setTrackFrameRate(int trackFrameRate) {
		this.trackFrameRate = trackFrameRate;
	}

	public List<Track> getTrack() {
		return track;
	}

	public void setTrack(List<Track> track) {
		this.track = track;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
}




