package com.viontech.keliu.content;

import com.viontech.keliu.content.Content;
import com.viontech.keliu.util.DateUtil;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by 苏曼 on 2018/8/15.
 */
public class MultiPCountRecordContent extends Content {
    private String vasid;
    private Date counttime;
    private String channelno;

    private List<Record> records = new ArrayList();
    public String getVasid() {
        return vasid;
    }

    public void setVasid(String vasid) {
        this.vasid = vasid;
    }



    public List<Record> getRecords() {
        return records;
    }

    public void addRecord(Record record){
        record.setVasid(this.getVasid());
        records.add(record);
    }

    public void setRecords(List<Record> records) {
        this.records = records;
    }

    public Date getCounttime() {
        return counttime;
    }

    public void setCounttime(Date counttime) {
        this.counttime = counttime;
    }

    public String getChannelno() {
        try{
            StringBuilder sb = new StringBuilder();
            sb.append(vasid).append("-");
            int channelnoInt = Integer.parseInt(channelno);
            channelnoInt+=1;
            if(channelnoInt<10){
                sb.append("0");
            }
            sb.append(channelnoInt);
            return sb.toString();
        }catch (Exception e){
            return channelno;
        }

    }

    public void setChannelno(String channelno) {
        this.channelno = channelno;
    }

    @Override
    public boolean isNeedResponse() {
        return true;
    }

     public static class Record {
         private String vasid;
         private String channelno;
         private String counttime;
         private Date countDate;
         private String personid;


         public String getPersonid() {
             return personid;
         }

         public void setPersonid(String personid) {
             this.personid = personid;
         }

         private Integer x;

         private Integer y;

         private Integer size;

         private Integer score;

         private Integer fx;//脚坐标

         private Integer fy;//脚坐标

         private Integer rx;//真实世界坐标

         private Integer ry;//真实世界坐标




         public String getVasid() {
             return vasid;
         }

         public void setVasid(String vasid) {
             this.vasid = vasid;
         }

         public String getChannelno() {
            try{
                StringBuilder sb = new StringBuilder();
                sb.append(vasid).append("-");
                int channelnoInt = Integer.parseInt(channelno);
                channelnoInt+=1;
                if(channelnoInt<10){
                    sb.append("0");
                }
                sb.append(channelnoInt);
                return sb.toString();
            }catch (Exception e){
                return channelno;
            }

         }

         public void setChannelno(String channelno) {
             this.channelno = channelno;
         }

         public String getCounttime() {
             return counttime;
         }

         public void setCounttime(String counttime) {
             this.counttime = counttime;
             try {
                 this.setCountDate(DateUtil.parse(DateUtil.FORMAT_LONG, counttime));
             } catch (ParseException e) {
             }
         }

         public Date getCountDate() {
             return countDate;
         }

         public void setCountDate(Date countDate) {
             this.countDate = countDate;
         }

         public Integer getX() {
             return x;
         }

         public void setX(Integer x) {
             this.x = x;
         }

         public Integer getY() {
             return y;
         }

         public void setY(Integer y) {
             this.y = y;
         }

         public Integer getSize() {
             return size;
         }

         public void setSize(Integer size) {
             this.size = size;
         }

         public Integer getScore() {
             return score;
         }

         public void setScore(Integer score) {
             this.score = score;
         }

         public Integer getFx() {
             return fx;
         }

         public void setFx(Integer fx) {
             this.fx = fx;
         }

         public Integer getFy() {
             return fy;
         }

         public void setFy(Integer fy) {
             this.fy = fy;
         }

         public Integer getRx() {
             return rx;
         }

         public void setRx(Integer rx) {
             this.rx = rx;
         }

         public Integer getRy() {
             return ry;
         }

         public void setRy(Integer ry) {
             this.ry = ry;
         }

     }

    @Override
    public String toString() {
        return "MultiPCountRecordContent{" +
                "vasid='" + vasid + '\'' +
                ", records=" + records +
                '}';
    }
}
