package com.viontech.keliu.content;


import com.viontech.keliu.model.Person;
import com.viontech.keliu.util.DateUtil;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;


public class FaceDataContent extends Content {

    /** personId */
    private String vasId;

    private int channelNo;
    private Long deviceId;
    private Long channelId;
    private String personId;
    private int direction;
    private int age;
    private int gender;
    private int mood;
    private int matchScore;
    private String startTime;
    private String faceImage;
    private int[] faceImageSzie;
    private float[] faceFeatrue;
    private String[] faceImageName;
    private int faceNum;
    private int faceFeatureLength;

    private String bodyImage;
    private int bodyImageSize;
    private String showBodyImage;
    private int showBodyImageSize;
    private float[] bodyfeature;
    private String[] bodyImageName;
    private String[] showBodyImageName;
    private int bodyNum;
    private int bodyFeatureLength;

    private String facePic;
    private String bodyPic;
    private String showBodyPic;
    private String facePicExt;
    private String bodyPicExt;
    private String showBodyPicExt;
    private Date countDate;
    private Long gateId;
    private Long mallId;
    private Long accountId;
    private String channelSerialnum;
    private Long personDBID;
    private Integer personType;
    private Integer status;
    private String facePath;
    private String bodyPath;

    //Reid业务增加数据信息
    //    private Integer trackType;//可能用于区分店员，包括驻留，迅速进入等等 -1:重复人员  0：顾客 1：店员 2：会员
    //    private Integer faceType;//当前字段暂时未使用
    //    private Integer ageConf;//年龄置信度 [0,100]
    //    private Integer genderConf;//性别置信度 [0,100]
    private Integer happyConf;//开心指数[0,100]
    private Integer trackLength;//轨迹长度,轨迹总帧数
    private Integer trackFrameRate;//轨迹视频的帧率
    //    private List<Track> tracks;//帧数据
    private String trackInfo;//帧文件名
    private String trackPath;//帧路径
    private String bodyFeature;//人体特征文件名
    private String faceFeature;//人脸特征文件名
    private Integer trackTime;//滞留时间
    /** 0,不处理，1，插入，2，更新 */
    private int needInsert = 0;
    /** 滞留时间 */
    private Integer residenceTime;
    /** 根据arrivalUnid(arrival_unid)(personId) 更新数据 */
    private String arrivalUnid;
    /** 进入时间 */
    private Date arrivalTime;
    /** 离开时间 */
    private Date leaveTime;
    /** 存储原始抓拍id */
    private String unid;
    /** 历史到店次数 */
    private Integer historyArrivalCount;
    /** 相机原始抓拍分数 */
    private Float face_score;
    /** 相机原始抓拍类型 */
    private Integer face_type;

    private Person person;

    private boolean noPicture = false;
    private Date receiveDate;

    public String getFacePath() {
        if (facePath == null) {
            facePath = "face/" + DateUtil.format("yyyyMMdd", getCountDate()) + "/" + getChannelSerialnum() + "/";
        }
        return facePath;
    }

    public void setFacePath(String facePath) {
        this.facePath = facePath;
    }

    public String getBodyPath() {
        if (bodyPath == null) {
            bodyPath = "body/" + DateUtil.format("yyyyMMdd", getCountDate()) + "/" + getChannelSerialnum() + "/";
        }
        return bodyPath;
    }

    public void setBodyPath(String bodyPath) {
        this.bodyPath = bodyPath;
    }

    public Integer getStatus() {
        if (status == null) {
            status = 0;
        }
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPersonType() {
        return personType;
    }

    public void setPersonType(Integer personType) {
        this.personType = personType;
    }

    public String getVasId() {
        return vasId;
    }

    public void setVasId(String vasId) {
        this.vasId = vasId;
    }

    public int getChannelNo() {
        return this.channelNo;
    }

    public String getChannelSerialnum() {
        if (channelSerialnum == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(vasId).append("-");
            int result = channelNo + 1;
            if (result < 10) {
                sb.append("0");
            }
            sb.append(result);
            channelSerialnum = sb.toString();
        }
        return channelSerialnum;

    }

    public void setChannelSerialnum(String channelSerialnum) {
        this.channelSerialnum = channelSerialnum;
    }

    public void setChannelNo(int channelNo) {
        this.channelNo = channelNo;
    }

    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public int getDirection() {
        return direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getGender() {
        return gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public int getMood() {
        return mood;
    }

    public void setMood(int mood) {
        this.mood = mood;
    }

    public int getMatchScore() {
        return matchScore;
    }

    public void setMatchScore(int matchScore) {
        this.matchScore = matchScore;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
        try {
            this.setCountDate(DateUtil.parse(DateUtil.FORMAT_LONG, startTime));
        } catch (ParseException e) {
        }
    }

    public String getFaceImage() {
        return faceImage;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void setFaceImage(String faceImage) {
        this.faceImage = faceImage;
    }

    public int[] getFaceImageSzie() {
        return faceImageSzie;
    }

    public void setFaceImageSzie(int[] faceImageSzie) {
        this.faceImageSzie = faceImageSzie;
    }

    public float[] getFaceFeatrue() {
        return faceFeatrue;
    }

    public void setFaceFeatrue(float[] faceFeatrue) {
        this.faceFeatrue = faceFeatrue;
    }

    public String[] getFaceImageName() {
        return faceImageName;
    }

    public void setFaceImageName(String[] faceImageName) {
        this.faceImageName = faceImageName;

        this.setFacePic(faceImageName == null || faceImageName.length <= 0 ? null : faceImageName[0]);
        this.setFacePicExt(faceImageName == null || faceImageName.length <= 0 ? null : Arrays.toString(faceImageName));
    }

    public int getFaceNum() {
        return faceNum;
    }

    public void setFaceNum(int faceNum) {
        this.faceNum = faceNum;
    }

    public int getFaceFeatureLength() {
        return faceFeatureLength;
    }

    public void setFaceFeatureLength(int faceFeatureLength) {
        this.faceFeatureLength = faceFeatureLength;
    }

    public String getBodyImage() {
        return bodyImage;
    }

    public void setBodyImage(String bodyImage) {
        this.bodyImage = bodyImage;
    }

    public int getBodyImageSize() {
        return bodyImageSize;
    }

    public void setBodyImageSize(int bodyImageSize) {
        this.bodyImageSize = bodyImageSize;
    }

    public String getShowBodyImage() {
        return showBodyImage;
    }

    public void setShowBodyImage(String showBodyImage) {
        this.showBodyImage = showBodyImage;
    }

    public int getShowBodyImageSize() {
        return showBodyImageSize;
    }

    public void setShowBodyImageSize(int showBodyImageSize) {
        this.showBodyImageSize = showBodyImageSize;
    }

    public float[] getBodyfeature() {
        return bodyfeature;
    }

    public void setBodyfeature(float[] bodyfeature) {
        this.bodyfeature = bodyfeature;
    }

    public String[] getBodyImageName() {
        return bodyImageName;
    }

    public void setBodyImageName(String[] bodyImageName) {
        this.bodyImageName = bodyImageName;
        this.setBodyImage(bodyImageName == null || bodyImageName.length <= 0 ? null : bodyImageName[0]);
        this.setBodyPic(bodyImageName == null || bodyImageName.length <= 0 ? null : bodyImageName[0]);
        this.setBodyPicExt(bodyImageName == null || bodyImageName.length <= 0 ? null : Arrays.toString(bodyImageName));
        this.setBodyFeature(bodyImageName == null || bodyImageName.length <= 0 ? null : bodyImageName[0]);
    }

    public String[] getShowBodyImageName() {
        return showBodyImageName;
    }

    public void setShowBodyImageName(String[] showBodyImageName) {
        this.showBodyImageName = showBodyImageName;
        this.setShowBodyImage(showBodyImageName == null ? null : showBodyImageName[0]);
        this.setShowBodyPic(showBodyImageName == null ? null : showBodyImageName[0]);
        this.setShowBodyPicExt(showBodyImageName == null ? null : Arrays.toString(showBodyImageName));
    }

    public int getBodyNum() {
        return bodyNum;
    }

    public void setBodyNum(int bodyNum) {
        this.bodyNum = bodyNum;
    }

    public int getBodyFeatureLength() {
        return bodyFeatureLength;
    }

    public void setBodyFeatureLength(int bodyFeatureLength) {
        this.bodyFeatureLength = bodyFeatureLength;
    }

    @Override
    public boolean isNeedResponse() {
        return true;
    }

    public String getFacePic() {
        return facePic;
    }

    public void setFacePic(String facePic) {
        this.facePic = facePic;
    }

    public String getFacePicExt() {
        return facePicExt;
    }

    public void setFacePicExt(String facePicExt) {
        this.facePicExt = facePicExt;
    }

    public String getBodyPicExt() {
        return bodyPicExt;
    }

    public void setBodyPicExt(String bodyPicExt) {
        this.bodyPicExt = bodyPicExt;
    }

    public String getShowBodyPicExt() {
        return showBodyPicExt;
    }

    public void setShowBodyPicExt(String showBodyPicExt) {
        this.showBodyPicExt = showBodyPicExt;
    }

    public String getBodyPic() {
        return bodyPic;
    }

    public void setBodyPic(String bodyPic) {
        this.bodyPic = bodyPic;
    }

    public String getShowBodyPic() {
        return showBodyPic;
    }

    public void setShowBodyPic(String showBodyPic) {
        this.showBodyPic = showBodyPic;
    }

    public Date getCountDate() {
        return countDate;
    }

    public void setCountDate(Date countDate) {
        this.countDate = countDate;
    }

    public Long getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getGateId() {
        return gateId;
    }

    public void setGateId(Long gateId) {
        this.gateId = gateId;
    }

    public Long getMallId() {
        return mallId;
    }

    public void setMallId(Long mallId) {
        this.mallId = mallId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getPersonDBID() {
        return personDBID;
    }

    public void setPersonDBID(Long personDBID) {
        this.personDBID = personDBID;
    }

    public void setHappyConf(Integer happyConf) {
        this.happyConf = happyConf;
    }

    public Integer getTrackLength() {
        return trackLength;
    }

    public void setTrackLength(Integer trackLength) {
        this.trackLength = trackLength;
    }

    public Integer getTrackFrameRate() {
        return trackFrameRate;
    }

    public void setTrackFrameRate(Integer trackFrameRate) {
        this.trackFrameRate = trackFrameRate;
    }

    public String getTrackInfo() {
        return trackInfo;
    }

    public void setTrackInfo(String trackInfo) {
        this.trackInfo = trackInfo;
    }

    public Integer getHappyConf() {
        return happyConf;
    }

    public String getTrackPath() {
        if (trackPath == null) {
            trackPath = "track/" + DateUtil.format("yyyyMMdd", getCountDate()) + "/" + getChannelSerialnum() + "/";
        }
        return trackPath;
    }

    public void setTrackPath(String trackPath) {
        this.trackPath = trackPath;
    }

    public String getBodyFeature() {
        return bodyFeature;
    }

    public void setBodyFeature(String bodyFeature) {
        this.bodyFeature = bodyFeature;
    }

    public String getFaceFeature() {
        return faceFeature;
    }

    public void setFaceFeature(String faceFeature) {
        this.faceFeature = faceFeature;
    }

    public Integer getTrackTime() {
        if (trackTime == null) {
            if (trackLength != null && trackFrameRate != null && trackFrameRate != 0) {
                trackTime = trackLength / trackFrameRate;
            }
        }
        return trackTime;
    }

    public void setTrackTime(Integer trackTime) {
        this.trackTime = trackTime;
    }

    public int isNeedInsert() {
        return needInsert;
    }

    public void setNeedInsert(int needInsert) {
        this.needInsert = needInsert;
    }

    public Integer getResidenceTime() {
        return residenceTime;
    }

    public void setResidenceTime(Integer residenceTime) {
        this.residenceTime = residenceTime;
    }

    public String getArrivalUnid() {
        return arrivalUnid;
    }

    public void setArrivalUnid(String arrivalUnid) {
        this.arrivalUnid = arrivalUnid;
    }

    public Date getArrivalTime() {
        return arrivalTime;
    }

    public void setArrivalTime(Date arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public Date getLeaveTime() {
        return leaveTime;
    }

    public void setLeaveTime(Date leaveTime) {
        this.leaveTime = leaveTime;
    }

    public int getNeedInsert() {
        return needInsert;
    }

    public String getUnid() {
        return unid;
    }

    public void setUnid(String unid) {
        this.unid = unid;
    }

    public Integer getHistoryArrivalCount() {
        return historyArrivalCount;
    }

    public void setHistoryArrivalCount(Integer historyArrivalCount) {
        this.historyArrivalCount = historyArrivalCount;
    }

    public Float getFace_score() {
        return face_score;
    }

    public void setFace_score(Float face_score) {
        this.face_score = face_score;
    }

    public Integer getFace_type() {
        return face_type;
    }

    public void setFace_type(Integer face_type) {
        this.face_type = face_type;
    }

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    @Override
    public String toString() {
        return "FaceDataContent{" +
                "vasId='" + vasId + '\'' +
                ", channelNo=" + channelNo +
                ", deviceId=" + deviceId +
                ", channelId=" + channelId +
                ", personId='" + personId + '\'' +
                ", direction=" + direction +
                ", age=" + age +
                ", gender=" + gender +
                ", mood=" + mood +
                ", matchScore=" + matchScore +
                ", startTime='" + startTime + '\'' +
                ", faceImage='" + faceImage + '\'' +
                ", faceImageSzie=" + Arrays.toString(faceImageSzie) +
                ", faceFeatrue=" + Arrays.toString(faceFeatrue) +
                ", faceImageName=" + Arrays.toString(faceImageName) +
                ", faceNum=" + faceNum +
                ", faceFeatureLength=" + faceFeatureLength +
                ", bodyImage='" + bodyImage + '\'' +
                ", bodyImageSize=" + bodyImageSize +
                ", showBodyImage='" + showBodyImage + '\'' +
                ", showBodyImageSize=" + showBodyImageSize +
                ", bodyfeature=" + Arrays.toString(bodyfeature) +
                ", bodyImageName=" + Arrays.toString(bodyImageName) +
                ", showBodyImageName=" + Arrays.toString(showBodyImageName) +
                ", bodyNum=" + bodyNum +
                ", bodyFeatureLength=" + bodyFeatureLength +
                ", facePic='" + facePic + '\'' +
                ", bodyPic='" + bodyPic + '\'' +
                ", showBodyPic='" + showBodyPic + '\'' +
                ", facePicExt='" + facePicExt + '\'' +
                ", bodyPicExt='" + bodyPicExt + '\'' +
                ", showBodyPicExt='" + showBodyPicExt + '\'' +
                ", countDate=" + countDate +
                ", gateId=" + gateId +
                ", mallId=" + mallId +
                ", accountId=" + accountId +
                ", channelSerialnum='" + channelSerialnum + '\'' +
                ", personDBID=" + personDBID +
                ", personType=" + personType +
                ", status=" + status +
                ", facePath='" + facePath + '\'' +
                ", bodyPath='" + bodyPath + '\'' +
                ", happyConf=" + happyConf +
                ", trackLength=" + trackLength +
                ", trackFrameRate=" + trackFrameRate +
                ", trackInfo='" + trackInfo + '\'' +
                ", trackPath='" + trackPath + '\'' +
                ", bodyFeature='" + bodyFeature + '\'' +
                ", faceFeature='" + faceFeature + '\'' +
                ", trackTime=" + trackTime +
                ", needInsert=" + needInsert +
                ", residenceTime=" + residenceTime +
                ", arrivalUnid='" + arrivalUnid + '\'' +
                ", arrivalTime=" + arrivalTime +
                ", leaveTime=" + leaveTime +
                '}';
    }

    public Integer getFacePicNum() {
        return getFaceImageName() == null ? 0 : getFaceImageName().length;
    }

    public Integer getBodyPicNum() {
        return getBodyImageName() == null ? 0 : getBodyImageName().length;
    }

    public Integer getfaceFeatureType() {
        if (getFaceFeature() == null) {
            return -1;
        }
        if (getFaceFeature().contains("-F.jpg")) {
            return 1;
        } else {
            return 0;
        }
    }

    public Integer getBodyFeatureType() {
        if (getBodyFeature() == null) {
            return -1;
        }
        if (getBodyFeature().contains("-F.jpg")) {
            return 1;
        } else {
            return 0;
        }
    }

    public boolean getNoPicture() {
        return noPicture;
    }

    public void setNoPicture(boolean noPicture) {
        this.noPicture = noPicture;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
}
