package com.viontech.keliu.constants;

import java.util.UUID;

/**
 * Created by vion on 2018/7/12.
 */
public class SystemConstants {
    /**
     * 人脸性别 男
     */
    public static final int FACE_GENDER_MALE = 1;
    /**
     * 人脸 性别 女
     */
    public static final int FACE_GENDER_FEMALE = 0;
    /**
     * 人脸 方向 进
     */
    public static final int FACE_DIRECTION_IN = 1;
    /**
     * 人脸 方向 出
     */
    public static final int FACE_DIRECTION_OUT = -1;
    /**
     * 人脸 方向 横穿
     */
    public static final int FACE_DIRECTION_ACROSS = 0;
    /**
     * 人脸 类型 店员
     */
    public static final int FACE_TYPE_STAFF = 1;
    /**
     * 人脸 类型 顾客
     */
    public static final int FACE_TYPE_CUSTOM = 0;
    /**
     * 组织机构 监控点绑定类型  正向  入口
     */
    public static final int ORG_GATE_BIND_TYPE_IN = 1;
    /**
     * 组织机构 监控点绑定类型 反向 出口
     */
    public static final int ORG_GATE_BIND_TYPE_OUT = 2;
    /**
     * 组织机构 监控点绑定类型 店外
     */
    public static final int ORG_GATE_BIND_TYPE_OUTSIDE = 3;

    /**
     * 监控点类型  客流监控点
     */
    public static final int GATE_TYPE_NUM = 1;

    /**
     * 监控点类型 进店率监控点
     */
    public static final int GATE_TYPE_ENTRIN_GRATE = 2;

    /**
     * 监控点类型 人脸客流监控点
     */
    public static final int GATE_TYPE_FACE = 3;


    /**
     * 监控点类型 热力图监控点
     */
    public static final int GATE_TYPE_HEATMAP = 4;

    /**
     * 监控点类型 仅人脸抓拍监控点
     */
    public static final int GATE_TYPE_ONLYFACE = 5;



    /**
    /**
     * 店员人脸map
     */
    public static final String FACE_STAFF_MAP = "faceStaffMap";
    /**
     * 通道近期抓拍map
     */
    public static final String CHANNEL_CAPTURE_MAP = "channelCaptureMap";
    /**
     * 设备心跳超时时间（毫秒）
     */
    public static final Long DEVICE_ALIVE_CHECK_MILLIS = 700000L;

    /**
     * 程序运行项目
     */
    public static final String WORKING_VERSION = UUID.randomUUID().toString();

    public static final int CHANNEL_TYPE_FACE = 1;
    public static final int CHANNEL_TYPE_COUNT = 2;
    public static final int CHANNEL_TYPE_HEATMAP = 3;

    public static final String FIELD_INNUM = "innum";
    public static final String FIELD_OUTNUM = "outnum";
    public static final String FIELD_OUTSIDE_INNUM = "outsideInum";
    public static final String FIELD_OUTSIDE_OUTNUM = "outsideOutnum";

    public static final String FLAG_UPDATE = "flagUpdate";
    public static final String FLAG_WRITE = "flagWrite";

    /**
     * 设备连接方式 http
     */
    public static final int DEVICE_CONNECTION_TYPE_HTTP = 1;
    /**
     * 设备连接方式 tcp
     */
    public static final int DEVICE_CONNECTION_TYPE_TCP = 2;

    public static final String AES_SEED = "lHnhwGAXvCCtGPmN";

}
