package com.viontech.keliu.configuration;

import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.FtpStorage;
import com.viontech.keliu.storage.LocalStorage;
import com.viontech.keliu.storage.OssStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StorageDatePathGenerator;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.File;

/**
 * Created by vion on 2018/8/7.
 */
@Configuration
@AutoConfigureAfter(FtpConfiguration.class)
public class StorageConfiguration {

    private Logger logger = LoggerFactory.getLogger(StorageConfiguration.class);
    @Bean("imageStorage")
    @ConditionalOnBean(OssClientHelper.class)
    public Storage ossImageStorage(StoragePathGenerator imagePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("ossImageStorage--------------------------");
        OssStorage ossImageStorage = new OssStorage();
        ossImageStorage.setConvert(new BufferedImageConvert());
        ossImageStorage.setOssClientHelper(ossClientHelper);
        ossImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ossImageStorage;
    }

    @Bean("featureStorage")
    @ConditionalOnBean(OssClientHelper.class)
    public Storage ossFeatureStorage(StoragePathGenerator featurePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("ossFeatureStorage----------------------");
        OssStorage ossFeatureStorage = new OssStorage();
        ossFeatureStorage.setConvert(new StringConvert());
        ossFeatureStorage.setOssClientHelper(ossClientHelper);
        ossFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ossFeatureStorage;
    }

    /**
     * @param simplePathGenerator
     * @param ossClientHelper
     * @return com.viontech.keliu.storage.Storage
     * @description 配置一个oss轨迹文件存储器
     */
    @Bean("simpleStringStorage")
    @ConditionalOnBean(OssClientHelper.class)
    public Storage simpleStringStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("配置一个轨迹文件存储器");
        OssStorage simpleStorage = new OssStorage();
        simpleStorage.setConvert(new StringConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }


    /**
     * @param simplePathGenerator
     * @param ossClientHelper
     * @return com.viontech.keliu.storage.Storage
     * @description 配置一个oss轨迹文件存储器
     */
    @Bean("simpleImageStorage")
    @ConditionalOnBean(OssClientHelper.class)
    public Storage simpleImageStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("配置一个轨迹文件存储器");
        OssStorage simpleStorage = new OssStorage();
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    /**
     * 配置一个FTP图片存储器
     *
     * @param imagePathGenerator
     * @param ftpClientHelper
     * @return
     */
    @Bean("imageStorage")
    @ConditionalOnBean(FTPClientHelper.class)
    @ConditionalOnMissingBean(name = "imageStorage")
    public Storage ftpImageStorage(StoragePathGenerator imagePathGenerator, FTPClientHelper ftpClientHelper) {
        logger.info(">>>>>>>>>>>FTP存储器构建成功");
        FtpStorage ftpImageStorage = new FtpStorage();
        ftpImageStorage.setFtpClientHelper(ftpClientHelper);
        ftpImageStorage.setConvert(new BufferedImageConvert());
        ftpImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ftpImageStorage;
    }

    /**
     * 配置一个轨迹文件存储器
     *
     * @param simplePathGenerator
     * @param ftpClientHelper
     * @return
     */
    @Bean("simpleStringStorage")
    @ConditionalOnBean(FTPClientHelper.class)
    @ConditionalOnMissingBean(name="simpleStringStorage")
    public Storage ftpSimpleStringStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        FtpStorage simpleStorage = new FtpStorage();
        simpleStorage.setFtpClientHelper(ftpClientHelper);
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }



    /**
     * 配置一个轨迹文件存储器
     *
     * @param simplePathGenerator
     * @param ftpClientHelper
     * @return
     */
    @Bean("simpleImageStorage")
    @ConditionalOnBean(FTPClientHelper.class)
    @ConditionalOnMissingBean(name="simpleImageStorage")
    public Storage ftpSimpleImageStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        FtpStorage simpleImageStorage = new FtpStorage();
        simpleImageStorage.setFtpClientHelper(ftpClientHelper);
        simpleImageStorage.setConvert(new BufferedImageConvert());
        simpleImageStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleImageStorage;
    }


    /**
     * 配置一个本地图片存储器
     *
     * @param imagePathGenerator
     * @return
     */
    @Bean("imageStorage")
    @ConditionalOnMissingBean(name = "imageStorage")
    public Storage localImageStorage(StoragePathGenerator imagePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localImageStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();

        }
        logger.info(">>>>>>>>>>>本地存储器构建成功" + path);
        localImageStorage.setBasePath(path);
        localImageStorage.setConvert(new BufferedImageConvert());
        localImageStorage.setStoragePathGenerator(imagePathGenerator);
        return localImageStorage;
    }

    /**
     * 配置一个本地轨迹文件存储器
     *
     * @param simplePathGenerator
     * @return
     */
    @Bean("simpleStringStorage")
    @ConditionalOnMissingBean(name="simpleStringStorage")
    public Storage localSimpleStringStorage(StoragePathGenerator simplePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localSimpleStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }

        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new StringConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    /**
     * 配置一个本地轨迹文件存储器
     *
     * @param simplePathGenerator
     * @return
     */
    @Bean("simpleImageStorage")
    @ConditionalOnMissingBean(name="simpleImageStorage")
    public Storage localSimpleImageStorage(StoragePathGenerator simplePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localSimpleStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new BufferedImageConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    /**
     * 配置一个特征文件存储器
     *
     * @param featurePathGenerator
     * @param ftpClientHelper
     * @return
     */
    @Bean("featureStorage")
    @ConditionalOnBean(FTPClientHelper.class)
    @ConditionalOnMissingBean(name = "featureStorage")
    public Storage ftpFeatureStorage(StoragePathGenerator featurePathGenerator, FTPClientHelper ftpClientHelper) {
        FtpStorage ftpFeatureStorage = new FtpStorage();
        ftpFeatureStorage.setFtpClientHelper(ftpClientHelper);
        ftpFeatureStorage.setConvert(new StringConvert());
        ftpFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ftpFeatureStorage;
    }

    /**
     * 配置一个本地特征文件存储器
     *
     * @param featurePathGenerator
     * @return
     */
    @Bean("featureStorage")
    @ConditionalOnMissingBean(name = "featureStorage")
    public Storage localFeatureStorage(StoragePathGenerator featurePathGenerator, @Value("${vion.storage.path:}") String path) {
        LocalStorage localFeatureStorage = new LocalStorage();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        localFeatureStorage.setBasePath(path);
        localFeatureStorage.setConvert(new StringConvert());
        localFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return localFeatureStorage;
    }


    @Bean("imagePathGenerator")
    public StoragePathGenerator imagePathGenerator() {
        StorageDatePathGenerator storagePathGenerator = new StorageDatePathGenerator();
        StringBuilder sb = new StringBuilder();
        sb.append("picture").append("/");
        storagePathGenerator.setPathPrefix(sb.toString());
        return storagePathGenerator;
    }

    @Bean("featurePathGenerator")
    public StoragePathGenerator featurePathGenerator() {
        StorageDatePathGenerator storagePathGenerator = new StorageDatePathGenerator();
        StringBuilder sb = new StringBuilder();
        sb.append("feature").append("/");
        storagePathGenerator.setPathPrefix(sb.toString());
        storagePathGenerator.setPathPostfix(".feature");
        return storagePathGenerator;
    }

    @Bean("simplePathGenerator")
    public StoragePathGenerator simpelPathGenerator() {
        return  name ->{
            return name;
        };
    }

}
