/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNumberUtil {
    private static Logger logger = LoggerFactory.getLogger(SerialNumberUtil.class);
    public static final String CPU_ID = "cpuId";
    public static final String DISK_ID = "diskId";
    public static final String MAINBOARD_ID = "mainboardId";
    public static final String LICENSE_DATE = "licenseDate";

    public static String getMotherboardSN() {
        String result = "";
        try {
            long start = System.currentTimeMillis();
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "csproduct", "get", "UUID"});
            process.getOutputStream().close();
            Scanner sc = new Scanner(process.getInputStream());
            String property = sc.next();
            result = sc.next();
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0CPU_ID\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    public static String getHardDiskSN(String drive) {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\nWscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + path);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public static String getCPUSerial() {
        String result = "";
        try {
            long start = System.currentTimeMillis();
            Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
            process.getOutputStream().close();
            Scanner sc = new Scanner(process.getInputStream());
            String property = sc.next();
            result = sc.next();
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        if (result.trim().length() < 1 || result == null) {
            result = "\u65e0CPU_ID\u88ab\u8bfb\u53d6";
        }
        return result.trim();
    }

    private static List<String> getLocalHostLANAddress() throws UnknownHostException, SocketException {
        ArrayList<String> ips = new ArrayList<String>();
        Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
        while (interfs.hasMoreElements()) {
            NetworkInterface interf = interfs.nextElement();
            Enumeration<InetAddress> addres = interf.getInetAddresses();
            while (addres.hasMoreElements()) {
                InetAddress in = addres.nextElement();
                if (!(in instanceof Inet4Address)) continue;
                System.out.println("v4:" + in.getHostAddress());
                if ("127.0.0.1".equals(in.getHostAddress())) continue;
                ips.add(in.getHostAddress());
            }
        }
        return ips;
    }

    public static String getMac() {
        try {
            String resultStr = "";
            List<String> ls = SerialNumberUtil.getLocalHostLANAddress();
            for (String str : ls) {
                InetAddress ia = InetAddress.getByName(str);
                byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    String s;
                    if (i != 0) {
                        sb.append("-");
                    }
                    sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
                }
                resultStr = resultStr + sb.toString().toUpperCase() + ",";
            }
            return resultStr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String executeLinuxCmd(String cmd) {
        try {
            int n;
            System.out.println("got cmd job : " + cmd);
            Runtime run = Runtime.getRuntime();
            Process process = run.exec(cmd);
            InputStream in = process.getInputStream();
            BufferedReader bs = new BufferedReader(new InputStreamReader(in));
            StringBuffer out = new StringBuffer();
            byte[] b = new byte[8192];
            while ((n = in.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            in.close();
            process.destroy();
            return out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSerialNumber(String cmd, String record, String symbol) {
        String[] infos;
        String execResult = SerialNumberUtil.executeLinuxCmd(cmd);
        for (String info : infos = execResult.split("\n")) {
            if ((info = info.trim()).indexOf(record) == -1) continue;
            info = info.replace(" ", "");
            String[] sn = info.split(symbol);
            return sn[1];
        }
        return null;
    }

    public static Map<String, String> getAllSn() {
        String os = System.getProperty("os.name");
        os = os.toUpperCase();
        System.out.println(os);
        HashMap<String, String> snVo = new HashMap<String, String>();
        if ("LINUX".equals(os)) {
            logger.info("=============>for linux");
            String cpuid = SerialNumberUtil.getSerialNumber("dmidecode -t processor | grep 'ID'", "ID", ":");
            logger.info("cpuid : " + cpuid);
            String mainboardNumber = SerialNumberUtil.getSerialNumber("dmidecode |grep 'Serial Number'", "Serial Number", ":");
            logger.info("mainboardNumber : " + mainboardNumber);
            String diskNumber = SerialNumberUtil.getSerialNumber("fdisk -l", "Disk identifier", ":");
            logger.info("diskNumber : " + diskNumber);
            snVo.put(CPU_ID, cpuid.toUpperCase().replace(" ", ""));
            snVo.put(DISK_ID, diskNumber.toUpperCase().replace(" ", ""));
            snVo.put(MAINBOARD_ID, mainboardNumber.toUpperCase().replace(" ", ""));
        } else {
            logger.info("=============>for windows");
            String cpuid = SerialNumberUtil.getCPUSerial();
            String mainboard = SerialNumberUtil.getMotherboardSN();
            String disk = SerialNumberUtil.getHardDiskSN("c");
            logger.info("CPU  SN:" + cpuid);
            logger.info("\u4e3b\u677f  SN:" + mainboard);
            logger.info("C\u76d8   SN:" + disk);
            snVo.put(CPU_ID, cpuid.toUpperCase().replace(" ", ""));
            snVo.put(DISK_ID, disk.toUpperCase().replace(" ", ""));
            snVo.put(MAINBOARD_ID, mainboard.toUpperCase().replace(" ", ""));
        }
        return snVo;
    }
}

