/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.processor.xml;

import com.viontech.keliu.content.Body;
import com.viontech.keliu.content.Content;
import com.viontech.keliu.processor.EarlierVionMessageProcessor;
import io.netty.buffer.ByteBuf;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class EarlierVionXmlMessageProcessor
extends EarlierVionMessageProcessor {
    private static final String ELEMENT_NAME_VENDOR = "vendor";
    private static final String ELEMENT_NAME_CATEGORY = "category";
    private static final String ELEMENT_NAME_MESSAGEID = "messageid";
    private static final String ELEMENT_NAME_SOURCE = "source";
    private static final String ELEMENT_NAME_DESTINATION = "destination";
    private static final String ELEMENT_NAME_CONTENT = "content";
    protected static final String CONTENT_PROPERTY_STASTUS = "status";
    protected static final String CONTENT_PROPERTY_ERRORDESC = "ErrorDesc";

    @Override
    public Body parseBody(ByteBuf byteBuf) {
        try {
            Body body = new Body();
            long size = byteBuf.getUnsignedIntLE(0);
            String xmlStr = byteBuf.readCharSequence((int)(size - 16L), charset).toString().trim();
            Document doc = DocumentHelper.parseText((String)xmlStr);
            Element rootElt = doc.getRootElement();
            try {
                Element vendorElement = rootElt.element(ELEMENT_NAME_VENDOR);
                if (vendorElement != null) {
                    String vendor = vendorElement.getTextTrim();
                    body.setVendor(vendor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Element categoryElement = rootElt.element(ELEMENT_NAME_CATEGORY);
                String category = categoryElement.getTextTrim();
                body.setCategory(category);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Element commandElement = rootElt.element("command");
                String command = commandElement.getTextTrim();
                body.setCommand(command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Element messageIdElement = rootElt.element(ELEMENT_NAME_MESSAGEID);
                String messageId = messageIdElement.getTextTrim();
                body.setMessageId(messageId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Element sourceElement = rootElt.element(ELEMENT_NAME_SOURCE);
                if (sourceElement != null) {
                    String source = sourceElement.getTextTrim();
                    body.setSource(source);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Element destinationElement = rootElt.element(ELEMENT_NAME_DESTINATION);
                if (destinationElement != null) {
                    String destination = destinationElement.getTextTrim();
                    body.setDestination(destination);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Element contentElement = rootElt.element(ELEMENT_NAME_CONTENT);
                Content content = this.parseContent(contentElement);
                body.setContent(content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return body;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract Content parseContent(Element var1);

    @Override
    public boolean isValid(ByteBuf byteBuf) {
        long size = byteBuf.getUnsignedInt(0);
        long version = byteBuf.getUnsignedInt(8);
        long type = byteBuf.getUnsignedInt(12);
        if (type != 1L) {
            return false;
        }
        Document doc = null;
        try {
            String xml = byteBuf.getCharSequence(16, (int)(size - 16L), charset).toString().trim();
            doc = DocumentHelper.parseText((String)xml);
            Element rootElt = doc.getRootElement();
            Element commandElement = rootElt.element("command");
            String command = commandElement.getTextTrim();
            if (command.equals(this.supportCommand()) && version == this.supportVersion()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected abstract boolean buildByteBufContent(Content var1, Element var2);

    @Override
    protected boolean buildByteBufBody(Body body, ByteBuf byteBuf) {
        try {
            Document document = DocumentHelper.createDocument();
            document.setXMLEncoding("GBK");
            Element root = document.addElement("rvss");
            Element vendor = root.addElement(ELEMENT_NAME_VENDOR);
            vendor.setText(body.getVendor());
            Element category = root.addElement(ELEMENT_NAME_CATEGORY);
            category.setText(this.getResponseCategory());
            Element command = root.addElement("command");
            command.setText(body.getCommand());
            Element messageId = root.addElement(ELEMENT_NAME_MESSAGEID);
            messageId.setText(body.getMessageId());
            Element content = root.addElement(ELEMENT_NAME_CONTENT);
            boolean success = this.buildByteBufContent(body.getContent(), content);
            if (!success) {
                return success;
            }
            String xmlStr = document.asXML();
            byteBuf.writeBytes(xmlStr.getBytes(charset));
            byteBuf.writeByte(0);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public long supportType() {
        return 1L;
    }
}

