/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.processor.binary;

import com.viontech.keliu.content.Body;
import com.viontech.keliu.content.Content;
import com.viontech.keliu.content.Image;
import com.viontech.keliu.processor.EarlierVionMessageProcessor;
import com.viontech.keliu.util.YuvToRGB;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;

public abstract class EarlierVionBinaryMessageProcessor
extends EarlierVionMessageProcessor {
    @Override
    public Body parseBody(ByteBuf byteBuf) {
        try {
            Body body = new Body();
            String msgId = this.readStr(byteBuf, 64);
            body.setMessageId(msgId);
            String command = this.readStr(byteBuf, 32);
            body.setCommand(command);
            String category = this.readStr(byteBuf, 32);
            body.setCategory(category);
            String contentName = this.readStr(byteBuf, 32);
            body.setContentName(contentName);
            String source = this.readStr(byteBuf, 32);
            body.setSource(source);
            String destination = this.readStr(byteBuf, 32);
            body.setDestination(destination);
            String reserved = this.readStr(byteBuf, 32);
            body.setReserved(reserved);
            Content content = this.parseContent(byteBuf);
            body.setContent(content);
            return body;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract Content parseContent(ByteBuf var1);

    public abstract boolean buildContent(Content var1, ByteBuf var2);

    public String readStr(ByteBuf byteBuf, int length) {
        String str = byteBuf.readCharSequence(length, charset).toString();
        String[] strArr = str.split("\u0000");
        if (strArr.length <= 0) {
            return "";
        }
        return strArr[0].trim();
    }

    @Override
    protected boolean buildByteBufBody(Body body, ByteBuf byteBuf) {
        try {
            byteBuf.writeBytes(this.transform(body.getMessageId(), 64));
            byteBuf.writeBytes(this.transform(body.getCommand(), 32));
            byteBuf.writeBytes(this.transform(this.getResponseCategory(), 32));
            byteBuf.writeBytes(this.transform(body.getContentName(), 32));
            byteBuf.writeBytes(this.transform(body.getSource(), 32));
            byteBuf.writeBytes(this.transform(body.getDestination(), 32));
            byteBuf.writeBytes(this.transform(body.getReserved(), 32));
            boolean success = this.buildContent(body.getContent(), byteBuf);
            return success;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isValid(ByteBuf byteBuf) {
        long version = byteBuf.getUnsignedInt(8);
        long type = byteBuf.getUnsignedInt(12);
        if (type != 2L) {
            return false;
        }
        CharSequence command = byteBuf.getCharSequence(80, 32, charset);
        String commandStr = command.toString().trim();
        return commandStr.equals(this.supportCommand()) && version == this.supportVersion();
    }

    protected Image parseYUV420Image(ByteBuf byteBuf) {
        int j;
        Image image = new Image();
        try {
            int version = byteBuf.readIntLE();
            image.setVersion(version);
        }
        catch (Exception e) {
            return null;
        }
        int type = byteBuf.readIntLE();
        image.setType(type);
        int channels = byteBuf.readIntLE();
        image.setChannels(channels);
        int depth = byteBuf.readIntLE();
        image.setDepth(depth);
        int origin = byteBuf.readIntLE();
        image.setOrigin(origin);
        int width = byteBuf.readIntLE();
        image.setWidth(width);
        int height = byteBuf.readIntLE();
        image.setHeight(height);
        int imageSize = byteBuf.readIntLE();
        image.setImageSize(imageSize);
        int abandoned = byteBuf.readIntLE();
        image.setAbandoned(abandoned);
        for (j = 0; j < 4; ++j) {
            byteBuf.readIntLE();
        }
        for (j = 0; j < 4; ++j) {
            byteBuf.readIntLE();
        }
        byteBuf.readIntLE();
        int[] reserveds = new int[4];
        for (int j2 = 0; j2 < 4; ++j2) {
            int reserved;
            reserveds[j2] = reserved = byteBuf.readIntLE();
        }
        image.setReserved(reserveds);
        BufferedImage bi = null;
        if (type == 1) {
            byte[] y = new byte[width * height];
            byteBuf.readBytes(y);
            byte[] u = new byte[width * height / 4];
            byteBuf.readBytes(u);
            byte[] v = new byte[width * height / 4];
            byteBuf.readBytes(v);
            bi = YuvToRGB.Yuv420ToImage(y, u, v, width, height);
        } else if (type == 17) {
            byte[] y = new byte[width * height];
            byteBuf.readBytes(y);
            byte[] u = new byte[width * height / 2];
            byteBuf.readBytes(u);
            bi = YuvToRGB.Yuv420PSUVToImage(y, u, width, height);
        }
        image.setBufferedImage(bi);
        return image;
    }

    @Override
    public long supportType() {
        return 2L;
    }
}

