/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.processor;

import com.viontech.keliu.content.Head;
import com.viontech.keliu.processor.VionMessageProcessor;
import io.netty.buffer.ByteBuf;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class EarlierVionMessageProcessor
extends VionMessageProcessor {
    @Override
    protected Head parseHead(ByteBuf byteBuf) {
        try {
            Head head = new Head();
            long size = byteBuf.readUnsignedIntLE();
            head.setSize(size);
            long check = byteBuf.readUnsignedIntLE();
            head.setCheck(check);
            long version = byteBuf.readUnsignedInt();
            head.setVersion(version);
            long type = byteBuf.readUnsignedInt();
            head.setType(type);
            return head;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCommandVersion(ByteBuf byteBuf) {
        long size = byteBuf.getUnsignedIntLE(0);
        long version = byteBuf.getUnsignedInt(8);
        long type = byteBuf.getUnsignedInt(12);
        if (type == 1L) {
            Document doc = null;
            try {
                String xml = byteBuf.getCharSequence(16, (int)(size - 16L), charset).toString().trim();
                doc = DocumentHelper.parseText((String)xml);
                Element rootElt = doc.getRootElement();
                Element commandElement = rootElt.element("command");
                String command = commandElement.getTextTrim();
                return command + "_" + type + "_" + version;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (type == 2L) {
            CharSequence command = byteBuf.getCharSequence(80, 32, charset);
            String commandStr = command.toString().split("\u0000")[0].trim();
            return commandStr + "_" + type + "_" + version;
        }
        return null;
    }
}

