/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.match;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.match.MatchService;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.model.MatchParam;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.model.Pool;
import com.viontech.keliu.model.Result;
import com.viontech.keliu.service.CreateFeaturePoolService;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMatchService
implements MatchService {
    private Logger logger = LoggerFactory.getLogger(AbstractMatchService.class);
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    private CreateFeaturePoolService createFeaturePoolService;

    @Override
    public List<Person> match(Person person, MatchParam matchParam) throws Exception {
        ArrayList<String> poolNames;
        CompletableFuture responseFuture;
        JSONObject response;
        Result result;
        Map<String, String> poolNameMap = this.buildPoolName(matchParam);
        if (poolNameMap == null || poolNameMap.size() <= 0) {
            this.logger.error("Bug \u6784\u5efa\u5339\u914d\u5e93\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        this.buildPerson(person);
        List originalBodyFeatures = person.getBodyFeatures();
        if (!matchParam.isMatchBody()) {
            person.setBodyFeatures(null);
        }
        if ((result = (Result)this.objectMapper.readValue((response = (JSONObject)(responseFuture = (poolNames = new ArrayList<String>(poolNameMap.keySet())).size() == 1 ? this.algApiClientComparison.matchPerson(2, person, (String)poolNames.get(0), Collections.emptyList(), new HashMap()) : this.algApiClientComparison.matchHistoryPerson(2, person, poolNames, new HashMap())).get(60L, TimeUnit.SECONDS)).toString(), Result.class)) == null) {
            this.logger.info("\u4eba\u5458\u5339\u914d\u7ed3\u675f \u6ca1\u6709\u7ed3\u679c \u76f4\u63a5\u8df3\u8fc7");
            return null;
        }
        Integer match = result.getMatch();
        Integer errCode = result.getErrCode();
        this.logger.info(response.toString());
        if (errCode != null && errCode == 4 && match == 0) {
            poolNameMap.forEach((poolName, type) -> this.buildPool((String)poolName, (String)type, matchParam.getMallId()));
            return this.match(person, matchParam);
        }
        List<Pool> personPoolStatus = result.getPersonPoolStatus();
        if (personPoolStatus != null && personPoolStatus.size() > 0) {
            boolean hasNewPool = false;
            for (Pool pool : personPoolStatus) {
                Integer status = pool.getStatus();
                String poolName2 = pool.getPersonPoolId();
                if (status != 1) continue;
                this.buildPool(poolName2, poolNameMap.get(poolName2), matchParam.getMallId());
                hasNewPool = true;
            }
            if (hasNewPool) {
                return this.match(person, matchParam);
            }
        }
        if (matchParam.isAppend() && !this.isMathedPerson(result)) {
            this.appendPerson2Pool(person, poolNames);
            return null;
        }
        List<Person> matchResult = this.analysisMatchPerson(person, poolNames, result.getMatchPersons(), result.getMatchBodies(), matchParam);
        person.setBodyFeatures(originalBodyFeatures);
        return matchResult;
    }

    private boolean isMathedPerson(Result result) {
        if (result.getSuccess() == 0) {
            return false;
        }
        if (result.getMatch() == 0) {
            return false;
        }
        if (result.getMatchPersons() != null && result.getMatchPersons().size() > 0) {
            return true;
        }
        return result.getMatchBodies() != null && result.getMatchBodies().size() > 0;
    }

    private List<Person> analysisMatchPerson(Person person, List<String> poolNames, List<Person> matchedPersons, List<Person> matchedBodies, MatchParam matchParam) {
        ArrayList<Person> result = new ArrayList<Person>();
        if (matchedPersons == null || matchedPersons.isEmpty()) {
            return result;
        }
        HashMap matchedMap = new HashMap();
        HashMap<String, Person> matchedBodyMap = new HashMap<String, Person>();
        matchedPersons.forEach(matchedPerson -> {
            Person p;
            Integer matchedScore = matchedPerson.getScore();
            this.logger.info("{} \u4eba\u8138\u5339\u914d\u5f97\u5206{}", (Object)person.getPersonId(), (Object)matchedScore);
            if (matchedScore > matchParam.getMatchThreshold() && ((p = (Person)matchedMap.get(matchedPerson.getPersonPoolId())) == null || matchedScore > p.getScore())) {
                matchedMap.put(matchedPerson.getPersonPoolId(), matchedPerson);
            }
        });
        Float faceScore = matchParam.getFaceScore();
        if (matchParam.isAppend()) {
            poolNames.forEach(poolName -> {
                Person matchedPerson = (Person)matchedMap.get(poolName);
                if (matchedPerson == null) {
                    this.logger.info("\u8ffd\u52a0\u65b0\u4eba\u5230 {} -\u56fe\u7247\u8d28\u91cf\u5206:{}", poolName, (Object)faceScore);
                    this.appendPerson2Pool(person, (String)poolName);
                } else if (matchedPerson.getScore() >= matchParam.getAppendThreshold()) {
                    this.logger.info("\u8ffd\u52a0\u4f18\u8d28\u8bc6\u522b\u7ed3\u679c {} \u5230 {}({}) -\u5339\u914d\u5f97\u5206:{},\u56fe\u7247\u8d28\u91cf\u5206:{}", new Object[]{person.getPersonId(), poolName, matchedPerson.getPersonId(), matchedPerson.getScore(), faceScore});
                    String originalPersonId = person.getPersonId();
                    person.setPersonId(matchedPerson.getPersonId());
                    this.appendPerson2Pool(person, (String)poolName);
                    person.setPersonId(originalPersonId);
                }
            });
        }
        result.addAll(matchedMap.values());
        if (matchParam.isMatchBody()) {
            if (matchedBodies == null) {
                return result;
            }
            matchedBodies.forEach(matchedBody -> {
                Person p;
                Integer score = matchedBody.getScore();
                this.logger.info("{} \u4eba\u4f53\u5339\u914d\u5f97\u5206{}", (Object)matchedBody.getPersonId(), (Object)score);
                if (score > matchParam.getMatchBodyThreshold() && ((p = (Person)matchedBodyMap.get(matchedBody.getPersonPoolId())) == null || score > p.getScore())) {
                    matchedBodyMap.put(matchedBody.getPersonPoolId(), (Person)matchedBody);
                }
            });
            matchedBodyMap.forEach((poolName, p) -> {
                if (matchedMap.get(poolName) == null) {
                    result.add((Person)p);
                }
            });
        }
        return result;
    }

    protected void buildPool(String poolName, String type, Long mallId) {
        this.logger.info("\u5f00\u59cb\u521b\u5efa\u4eba\u5458\u6c60{} ", (Object)poolName);
        JSONObject jsonObject = this.createFeaturePoolService.createFeaturePool(poolName);
        if (jsonObject == null) {
            this.logger.warn("\u7279\u5f81\u5e93:{}\u521b\u5efa\u5f02\u5e38", (Object)poolName);
            return;
        }
        if (jsonObject.getInt("errCode") == 20) {
            this.logger.warn("\u7279\u5f81\u5e93\uff1a{}\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u521b\u5efa\u589e\u52a0\u4eba\u5458\u6b65\u9aa4", (Object)poolName);
            return;
        }
        List<Person> persons = this.getPersons(mallId, type);
        int size = 0;
        for (Person person : persons) {
            if (!this.buildPerson(person)) continue;
            this.appendPerson2Pool(person, poolName);
            ++size;
        }
        this.logger.info("\u521b\u5efa\u4eba\u5458\u6c60{} \u5b8c\u6210\uff0c\u6dfb\u52a0\u4eba\u6570{}", (Object)poolName, (Object)size);
    }

    private boolean buildPerson(Person person) {
        boolean result = false;
        try {
            List bodyFeaturesNew;
            List bodyFeatures;
            List faceFeaturesNew;
            List faceFeatures = person.getFaceFeatures();
            if (faceFeatures != null && !faceFeatures.isEmpty() && (faceFeaturesNew = faceFeatures.stream().filter(item -> this.buildFaceFeature((FaceFeature)item)).collect(Collectors.toList())) != null && !faceFeaturesNew.isEmpty()) {
                if (!result) {
                    // empty if block
                }
                result = true;
                person.setFaceFeatures(faceFeaturesNew);
            }
            if ((bodyFeatures = person.getBodyFeatures()) != null && !bodyFeatures.isEmpty() && (bodyFeaturesNew = bodyFeatures.stream().filter(item -> this.buildBodyFeature((BodyFeature)item)).collect(Collectors.toList())) != null && !bodyFeaturesNew.isEmpty()) {
                if (!result) {
                    // empty if block
                }
                result = true;
                person.setBodyFeatures(bodyFeaturesNew);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u5e38\uff01\uff01", (Throwable)e);
        }
        return result;
    }

    private boolean buildFaceFeature(FaceFeature faceFeature) {
        if (faceFeature.getFeature() != null && faceFeature.getFeature().length > 0) {
            return true;
        }
        String featureStr = this.readFeature(faceFeature.getPicName());
        if (featureStr == null && (featureStr = this.reExractFaceFeature(faceFeature.getPicName())) == null) {
            return false;
        }
        Double[] featureArr = this.buildFeature(featureStr);
        faceFeature.setFeature(featureArr);
        return true;
    }

    private boolean buildBodyFeature(BodyFeature bodyFeature) {
        if (bodyFeature.getFeature() != null && bodyFeature.getFeature().length > 0) {
            return true;
        }
        String featureStr = this.readFeature(bodyFeature.getPicName());
        if (featureStr == null && (featureStr = this.reExractBodyFeature(bodyFeature.getPicName())) == null) {
            return false;
        }
        Double[] featureArr = this.buildFeature(featureStr);
        if (featureArr == null) {
            return false;
        }
        bodyFeature.setFeature(featureArr);
        return true;
    }

    private Double[] buildFeature(String featureStr) {
        Integer faceType;
        Feature feature = null;
        try {
            feature = (Feature)this.objectMapper.readValue(featureStr, Feature.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (feature == null) {
            return null;
        }
        if ("face".equals(feature.getType()) && (faceType = feature.getFace_type()) != null && faceType != 1) {
            return null;
        }
        List<Data> datas = feature.getDatas();
        if (datas == null || datas.isEmpty()) {
            return null;
        }
        Optional<Data> dataResult = datas.stream().filter(item -> "server".equals(item.getType())).findFirst();
        Data data = new Data();
        if (dataResult.isPresent()) {
            data = dataResult.get();
        }
        if (data == null || data.getType() == null) {
            return null;
        }
        return data.getData();
    }

    protected abstract List<Person> getPersons(Long var1, String var2);

    protected boolean appendPerson2Pool(Person person, List<String> poolNames) {
        poolNames.forEach(poolName -> this.appendPerson2Pool(person, (String)poolName));
        return true;
    }

    protected boolean appendPerson2Pool(Person person, String poolName) {
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(person);
        try {
            this.algApiClientComparison.modifyPersonPool(poolName, 2, 2, persons, new HashMap());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected abstract String readFeature(String var1);

    protected String reExractFaceFeature(String file) {
        return null;
    }

    protected String reExractBodyFeature(String file) {
        return null;
    }

    protected abstract Map<String, String> buildPoolName(MatchParam var1);
}

