/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import com.viontech.keliu.configuration.FtpConfiguration;
import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.FtpStorage;
import com.viontech.keliu.storage.LocalStorage;
import com.viontech.keliu.storage.OssStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StorageDatePathGenerator;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={FtpConfiguration.class})
public class StorageConfiguration {
    private Logger logger = LoggerFactory.getLogger(StorageConfiguration.class);

    @Bean(value={"imageStorage"})
    @ConditionalOnBean(value={OssClientHelper.class})
    public Storage ossImageStorage(StoragePathGenerator imagePathGenerator, OssClientHelper ossClientHelper) {
        this.logger.info("ossImageStorage--------------------------");
        OssStorage<BufferedImage> ossImageStorage = new OssStorage<BufferedImage>();
        ossImageStorage.setConvert(new BufferedImageConvert());
        ossImageStorage.setOssClientHelper(ossClientHelper);
        ossImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ossImageStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnBean(value={OssClientHelper.class})
    public Storage ossFeatureStorage(StoragePathGenerator featurePathGenerator, OssClientHelper ossClientHelper) {
        this.logger.info("ossFeatureStorage----------------------");
        OssStorage<String> ossFeatureStorage = new OssStorage<String>();
        ossFeatureStorage.setConvert(new StringConvert());
        ossFeatureStorage.setOssClientHelper(ossClientHelper);
        ossFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ossFeatureStorage;
    }

    @Bean(value={"simpleStringStorage"})
    @ConditionalOnBean(value={OssClientHelper.class})
    public Storage simpleStringStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        this.logger.info("\u914d\u7f6e\u4e00\u4e2a\u8f68\u8ff9\u6587\u4ef6\u5b58\u50a8\u5668");
        OssStorage<String> simpleStorage = new OssStorage<String>();
        simpleStorage.setConvert(new StringConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    @Bean(value={"simpleImageStorage"})
    @ConditionalOnBean(value={OssClientHelper.class})
    public Storage simpleImageStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        this.logger.info("\u914d\u7f6e\u4e00\u4e2a\u8f68\u8ff9\u6587\u4ef6\u5b58\u50a8\u5668");
        OssStorage<BufferedImage> simpleStorage = new OssStorage<BufferedImage>();
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    @Bean(value={"imageStorage"})
    @ConditionalOnBean(value={FTPClientHelper.class})
    @ConditionalOnMissingBean(name={"imageStorage"})
    public Storage ftpImageStorage(StoragePathGenerator imagePathGenerator, FTPClientHelper ftpClientHelper) {
        this.logger.info(">>>>>>>>>>>FTP\u5b58\u50a8\u5668\u6784\u5efa\u6210\u529f");
        FtpStorage<BufferedImage> ftpImageStorage = new FtpStorage<BufferedImage>();
        ftpImageStorage.setFtpClientHelper(ftpClientHelper);
        ftpImageStorage.setConvert(new BufferedImageConvert());
        ftpImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ftpImageStorage;
    }

    @Bean(value={"simpleStringStorage"})
    @ConditionalOnBean(value={FTPClientHelper.class})
    @ConditionalOnMissingBean(name={"simpleStringStorage"})
    public Storage ftpSimpleStringStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        FtpStorage<BufferedImage> simpleStorage = new FtpStorage<BufferedImage>();
        simpleStorage.setFtpClientHelper(ftpClientHelper);
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    @Bean(value={"simpleImageStorage"})
    @ConditionalOnBean(value={FTPClientHelper.class})
    @ConditionalOnMissingBean(name={"simpleImageStorage"})
    public Storage ftpSimpleImageStorage(StoragePathGenerator simplePathGenerator, FTPClientHelper ftpClientHelper) {
        FtpStorage<BufferedImage> simpleImageStorage = new FtpStorage<BufferedImage>();
        simpleImageStorage.setFtpClientHelper(ftpClientHelper);
        simpleImageStorage.setConvert(new BufferedImageConvert());
        simpleImageStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleImageStorage;
    }

    @Bean(value={"imageStorage"})
    @ConditionalOnMissingBean(name={"imageStorage"})
    public Storage localImageStorage(StoragePathGenerator imagePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<BufferedImage> localImageStorage = new LocalStorage<BufferedImage>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        this.logger.info(">>>>>>>>>>>\u672c\u5730\u5b58\u50a8\u5668\u6784\u5efa\u6210\u529f" + path);
        localImageStorage.setBasePath(path);
        localImageStorage.setConvert(new BufferedImageConvert());
        localImageStorage.setStoragePathGenerator(imagePathGenerator);
        return localImageStorage;
    }

    @Bean(value={"simpleStringStorage"})
    @ConditionalOnMissingBean(name={"simpleStringStorage"})
    public Storage localSimpleStringStorage(StoragePathGenerator simplePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<String> localSimpleStorage = new LocalStorage<String>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new StringConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    @Bean(value={"simpleImageStorage"})
    @ConditionalOnMissingBean(name={"simpleImageStorage"})
    public Storage localSimpleImageStorage(StoragePathGenerator simplePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<BufferedImage> localSimpleStorage = new LocalStorage<BufferedImage>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        localSimpleStorage.setBasePath(path);
        localSimpleStorage.setConvert(new BufferedImageConvert());
        localSimpleStorage.setStoragePathGenerator(simplePathGenerator);
        return localSimpleStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnBean(value={FTPClientHelper.class})
    @ConditionalOnMissingBean(name={"featureStorage"})
    public Storage ftpFeatureStorage(StoragePathGenerator featurePathGenerator, FTPClientHelper ftpClientHelper) {
        FtpStorage<String> ftpFeatureStorage = new FtpStorage<String>();
        ftpFeatureStorage.setFtpClientHelper(ftpClientHelper);
        ftpFeatureStorage.setConvert(new StringConvert());
        ftpFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ftpFeatureStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnMissingBean(name={"featureStorage"})
    public Storage localFeatureStorage(StoragePathGenerator featurePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalStorage<String> localFeatureStorage = new LocalStorage<String>();
        if (path == null || path.trim().isEmpty()) {
            File f = new File("/");
            path = f.getAbsolutePath();
        }
        localFeatureStorage.setBasePath(path);
        localFeatureStorage.setConvert(new StringConvert());
        localFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return localFeatureStorage;
    }

    @Bean(value={"imagePathGenerator"})
    public StoragePathGenerator imagePathGenerator() {
        StorageDatePathGenerator storagePathGenerator = new StorageDatePathGenerator();
        StringBuilder sb = new StringBuilder();
        sb.append("picture").append("/");
        storagePathGenerator.setPathPrefix(sb.toString());
        return storagePathGenerator;
    }

    @Bean(value={"featurePathGenerator"})
    public StoragePathGenerator featurePathGenerator() {
        StorageDatePathGenerator storagePathGenerator = new StorageDatePathGenerator();
        StringBuilder sb = new StringBuilder();
        sb.append("feature").append("/");
        storagePathGenerator.setPathPrefix(sb.toString());
        storagePathGenerator.setPathPostfix(".feature");
        return storagePathGenerator;
    }

    @Bean(value={"simplePathGenerator"})
    public StoragePathGenerator simpelPathGenerator() {
        return name -> name;
    }
}

