/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.util.SpringContextUtils;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/webSocket/log")
@Component
public class LogWebSocket {
    private String serialnum;
    private Logger logger = LoggerFactory.getLogger(LogWebSocket.class);
    private static CopyOnWriteArraySet<LogWebSocket> webSocketSet = new CopyOnWriteArraySet();
    private Session session;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="serialnum") String serialnum) {
        this.serialnum = serialnum;
        this.session = session;
        webSocketSet.add(this);
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
    }

    @OnError
    public void onError(Session session, Throwable error) {
        this.logger.debug("\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public void sendMessage(Object message) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)SpringContextUtils.getBean("objectMapper");
        String messageStr = objectMapper.writeValueAsString(message);
        this.sendMessage(messageStr);
    }

    public static void sendInfo(String serialnum, Object message) throws IOException {
        for (LogWebSocket item : webSocketSet) {
            try {
                if (!item.isNeedSend(serialnum)) continue;
                item.sendMessage(message);
            }
            catch (IOException e) {}
        }
    }

    public static void sendInfo(Object message) throws IOException {
        LogWebSocket.sendInfo(null, message);
    }

    public boolean isNeedSend(String serialnum) {
        if (this.serialnum == null || serialnum == null) {
            return true;
        }
        return this.serialnum.equals(serialnum);
    }
}

