/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.StoragePathGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathStorage<T>
implements Storage<T> {
    private final Logger logger = LoggerFactory.getLogger(PathStorage.class);
    protected StoragePathGenerator storagePathGenerator = name -> name;

    public StoragePathGenerator getStoragePathGenerator() {
        return this.storagePathGenerator;
    }

    public void setStoragePathGenerator(StoragePathGenerator storagePathGenerator) {
        this.storagePathGenerator = storagePathGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readFile(File file) throws IOException {
        try (FileInputStream fi = null;){
            int offset;
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                byte[] byArray = null;
                return byArray;
            }
            fi = new FileInputStream(file);
            byte[] buffer = new byte[(int)fileSize];
            int numRead = 0;
            for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFile2Json(File file) throws IOException {
        try (FileInputStream fi = null;){
            int offset;
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                String string = null;
                return string;
            }
            fi = new FileInputStream(file);
            byte[] buffer = new byte[(int)fileSize];
            int numRead = 0;
            for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
            }
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            String string = new String(buffer, 0, buffer.length);
            return string;
        }
    }
}

