/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.PathStorage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class OssImageStorage
extends PathStorage<BufferedImage> {
    private OssClientHelper ossClientHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String key, BufferedImage item) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)item, "jpg", outputStream);
            byte[] bytes = outputStream.toByteArray();
            this.ossClientHelper.storeFile(this.storagePathGenerator.generator(key), bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BufferedImage getItem(String key) {
        try {
            return this.ossClientHelper.getBufferedImage(this.storagePathGenerator.generator(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return this.ossClientHelper.getByteArrayImage(this.storagePathGenerator.generator(key));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OssClientHelper getOssClientHelper() {
        return this.ossClientHelper;
    }

    public void setOssClientHelper(OssClientHelper ossClientHelper) {
        this.ossClientHelper = ossClientHelper;
    }
}

