/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.storage.PathStorage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class LocalImageStorage
extends PathStorage<BufferedImage> {
    private String basePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String key, BufferedImage item) {
        OutputStream output = null;
        try {
            File file = new File(this.basePath, this.storagePathGenerator.generator(key));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            output = new FileOutputStream(file);
            ImageIO.write((RenderedImage)item, "jpg", output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.flush();
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BufferedImage getItem(String key) {
        try {
            File file = new File(this.basePath, this.storagePathGenerator.generator(key));
            if (!file.exists()) {
                return null;
            }
            if (file.getParentFile().exists()) return ImageIO.read(file);
            file.getParentFile().mkdirs();
            return ImageIO.read(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            File file = new File(this.basePath, this.storagePathGenerator.generator(key));
            if (file.getParentFile().exists()) return this.readFile(file);
            file.getParentFile().mkdirs();
            return this.readFile(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

