/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.storage.PathStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFeatureStorage
extends PathStorage<String> {
    private String basePath;
    private final Logger logger = LoggerFactory.getLogger(LocalFeatureStorage.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String key, String item) {
        OutputStream fos = null;
        try {
            File file = new File(this.basePath, this.storagePathGenerator.generator(key));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            int jsonLength = item.length();
            byte[] jsonBytes = item.getBytes();
            ((FileOutputStream)fos).write(jsonBytes, 0, jsonLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getItem(String key) {
        String json = this.getJsonArrayItem(key);
        if (json == null) {
            return null;
        }
        return json;
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        File file = new File(this.basePath, this.storagePathGenerator.generator(key));
        try {
            return this.readFile(file);
        }
        catch (IOException e) {
            this.logger.error("getByteArrayItem", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public String getJsonArrayItem(String key) {
        File file = new File(this.basePath, this.storagePathGenerator.generator(key));
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u7279\u5f81" + file.getAbsolutePath());
        try {
            String s = this.readFile2Json(file);
            return s;
        }
        catch (IOException e) {
            this.logger.info("\u7279\u5f81\u83b7\u53d6\u5931\u8d25" + file.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

