/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.storage;

import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.storage.PathStorage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class FtpImageStorage
extends PathStorage<BufferedImage> {
    private FTPClientHelper ftpClientHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String key, BufferedImage item) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)item, "jpg", outputStream);
            byte[] bytes = outputStream.toByteArray();
            this.ftpClientHelper.storeFile(this.storagePathGenerator.generator(key), bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BufferedImage getItem(String key) {
        try {
            byte[] bytes = this.ftpClientHelper.retrieveFileStream(this.storagePathGenerator.generator(key));
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            BufferedImage image = ImageIO.read(in);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            byte[] bytes = this.ftpClientHelper.retrieveFileStream(this.storagePathGenerator.generator(key));
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public FTPClientHelper getFtpClientHelper() {
        return this.ftpClientHelper;
    }

    public void setFtpClientHelper(FTPClientHelper ftpClientHelper) {
        this.ftpClientHelper = ftpClientHelper;
    }
}

