/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.processor;

import com.viontech.keliu.model.Body;
import com.viontech.keliu.model.Head;
import com.viontech.keliu.model.Message;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;

public abstract class VionMessageProcessor {
    public static final int MESSAGE_TYPE_BINARY = 2;
    public static final int MESSAGE_TYPE_XML = 1;
    protected Charset charset = null;

    public VionMessageProcessor() {
        if (!Charset.isSupported("GB2312")) {
            throw new UnsupportedCharsetException("GB2312");
        }
        this.charset = Charset.forName("GB2312");
    }

    public Message process(ByteBuf byteBuf) {
        return this.process(byteBuf, null);
    }

    public Message process(ByteBuf byteBuf, String deviceSerialnum) {
        Message message = new Message();
        if (deviceSerialnum != null && message.getSerialNum() == null) {
            message.setSerialNum(deviceSerialnum);
        }
        Head head = this.parseHead(byteBuf);
        message.setHead(head);
        Body body = this.parseBody(byteBuf);
        message.setBody(body);
        int readable = byteBuf.readerIndex() + byteBuf.readableBytes();
        byte[] bytes = new byte[readable];
        byteBuf.getBytes(0, bytes);
        boolean success = this.doProcess(message, bytes);
        return message;
    }

    public abstract boolean doProcess(Message var1, byte[] var2);

    private Head parseHead(ByteBuf byteBuf) {
        try {
            Head head = new Head();
            long size = byteBuf.readUnsignedInt();
            head.setSize(size);
            long check = byteBuf.readUnsignedInt();
            head.setCheck(check);
            long version = byteBuf.readUnsignedInt();
            head.setVersion(version);
            long type = byteBuf.readUnsignedInt();
            head.setType(type);
            return head;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract Body parseBody(ByteBuf var1);

    public abstract boolean isValid(ByteBuf var1);

    public abstract void log(Message var1);

    private boolean buildByteBufHead(Head head, ByteBuf byteBuf) {
        try {
            byteBuf.writeInt(0);
            byteBuf.writeInt(0);
            byteBuf.writeInt((int)head.getVersion());
            byteBuf.writeInt((int)head.getType());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected abstract boolean buildByteBufBody(Body var1, ByteBuf var2);

    public ByteBuf buildByteBuf(Message message) {
        if (!message.isNeedResponse()) {
            return null;
        }
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        boolean success = this.buildByteBufHead(message.getHead(), byteBuf);
        if (!success) {
            return null;
        }
        success = this.buildByteBufBody(message.getBody(), byteBuf);
        if (!success) {
            return null;
        }
        int size = byteBuf.writerIndex();
        byteBuf.setInt(0, size);
        byteBuf.setInt(4, size ^ 0x7781E715);
        return byteBuf;
    }

    protected abstract String supportCommand();

    protected abstract long supportVersion();

    protected byte[] transform(String str, int length) {
        byte[] bytes = str.getBytes(this.charset);
        return Arrays.copyOf(bytes, length);
    }

    protected abstract String getResponseCategory();
}

