/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.IOUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssClientHelper {
    Logger log = LoggerFactory.getLogger(OssClientHelper.class);
    private String key;
    private String secret;
    private String endPoint;
    private String bucket;
    private static OSSClient ossClient;

    public OSSClient getClient() {
        if (ossClient == null) {
            ClientConfiguration conf = new ClientConfiguration();
            conf.setRequestTimeoutEnabled(true);
            conf.setRequestTimeout(10000000);
            conf.setConnectionTimeout(10000000);
            ossClient = new OSSClient(this.endPoint, this.key, this.secret, conf);
        }
        return ossClient;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String storeFile(String remoteFile, InputStream stream) {
        OSSClient ossClient = this.getClient();
        return ossClient.putObject(this.bucket, remoteFile, stream).getETag();
    }

    public String storeFile(String remoteFile, byte[] content) {
        OSSClient ossClient = this.getClient();
        return ossClient.putObject(this.bucket, remoteFile, (InputStream)new ByteArrayInputStream(content)).getETag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getItem(String key) {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClient().getObject(this.bucket, key).getObjectContent()));
        StringBuilder sb = new StringBuilder();
        try {
            String s;
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (Exception e) {
            this.log.info("oss getItem error");
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public byte[] getByteArray(String key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            return IOUtils.readStreamAsByteArray((InputStream)this.getClient().getObject(this.bucket, key).getObjectContent());
        }
        catch (IOException e) {
            this.log.info("oss getByteArray error");
            return new byte[0];
        }
    }

    public BufferedImage getBufferedImage(String key) {
        try {
            return ImageIO.read(this.getClient().getObject(this.bucket, key).getObjectContent());
        }
        catch (IOException e) {
            this.log.info("oss getBufferedImage error");
            return null;
        }
    }

    public byte[] getByteArrayImage(String key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            return IOUtils.readStreamAsByteArray((InputStream)this.getClient().getObject(this.bucket, key).getObjectContent());
        }
        catch (IOException e) {
            this.log.error("oss getByteArrayImage error");
            e.printStackTrace();
            return null;
        }
    }
}

