/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.ftp;

import com.viontech.keliu.ftp.FTPClientPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPClientHelper {
    private Logger logger = LoggerFactory.getLogger(FTPClientHelper.class);
    private FTPClientPool ftpClientPool;
    private String tempPath;
    private int retryCount = 3;

    public void setFtpClientPool(FTPClientPool ftpClientPool) {
        this.ftpClientPool = ftpClientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieveFileStream(String remote) {
        FTPClient client = null;
        ByteArrayOutputStream out = null;
        try {
            this.logger.info("\u5f00\u59cb\u83b7\u53d6FTPClient\u5bf9\u8c61");
            client = this.ftpClientPool.borrowObject();
            this.logger.info("\u7ed3\u675f\u83b7\u53d6FTPClient\u5bf9\u8c61");
            out = new ByteArrayOutputStream();
            this.logger.info("\u5f00\u59cb\u83b7\u53d6\u6587\u4ef6");
            boolean result = client.retrieveFile(remote, (OutputStream)out);
            this.logger.info("\u7ed3\u675f\u83b7\u53d6\u6587\u4ef6" + result);
            if (result) {
                byte[] byArray = out.toByteArray();
                return byArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.ftpClientPool.returnObject(client);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean makeDirectory(String pathname) throws Exception {
        FTPClient client = null;
        try {
            client = this.ftpClientPool.borrowObject();
            boolean bl = client.makeDirectory(pathname);
            return bl;
        }
        finally {
            this.ftpClientPool.returnObject(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDirectory(String pathname) throws Exception {
        FTPClient client = null;
        try {
            client = this.ftpClientPool.borrowObject();
            boolean bl = client.removeDirectory(pathname);
            return bl;
        }
        finally {
            this.ftpClientPool.returnObject(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String pathname) throws Exception {
        FTPClient client = null;
        try {
            client = this.ftpClientPool.borrowObject();
            boolean bl = client.deleteFile(pathname);
            return bl;
        }
        finally {
            this.ftpClientPool.returnObject(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeFile(String remote, InputStream local) {
        Exception throwException = null;
        for (int i = 0; i < this.retryCount; ++i) {
            FTPClient client = null;
            try {
                client = this.ftpClientPool.borrowObject();
                boolean result = client.storeFile(remote, local);
                if (!result) continue;
                boolean bl = result;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                throwException = e;
                continue;
            }
            finally {
                if (local != null) {
                    try {
                        local.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.ftpClientPool.returnObject(client);
            }
        }
        this.logger.error("\u901a\u8fc7ftp\u5b58\u50a8\u6587\u4ef6" + remote + "\u65f6\u53d1\u751f\u5f02\u5e38 \uff0c\u5f00\u59cb\u5c1d\u8bd5\u5b58\u50a8\u5230\u672c\u5730\u8def\u5f84" + this.tempPath + "\u4e0b", (Throwable)throwException);
        return this.storeTemp(remote, local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeFile(String remote, byte[] content) {
        Exception throwException = null;
        for (int i = 0; i < this.retryCount; ++i) {
            Long startTime = System.currentTimeMillis();
            FTPClient client = null;
            ByteArrayInputStream bis = null;
            try {
                boolean result;
                client = this.ftpClientPool.borrowObject();
                String parentPath = this.getParentPath(remote);
                boolean makeDirectoryResult = client.makeDirectory(parentPath);
                if (!makeDirectoryResult) {
                    this.makeDirectorys(client, parentPath);
                }
                if (result = client.storeFile(remote, (InputStream)(bis = new ByteArrayInputStream(content)))) {
                    boolean bl = result;
                    return bl;
                }
                this.logger.error("\u901a\u8fc7ftp\u5b58\u50a8\u6587\u4ef6" + remote + "\u65f6\u672a\u53d1\u751f\u5f02\u5e38 \uff0c\u4f46\u5b58\u50a8\u5931\u8d25");
                boolean bl = result;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                throwException = e;
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.ftpClientPool.returnObject(client);
                Long l = System.currentTimeMillis();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.logger.error("\u901a\u8fc7ftp\u5b58\u50a8\u6587\u4ef6" + remote + "\u65f6\u53d1\u751f\u5f02\u5e38 \uff0c\u5f00\u59cb\u5c1d\u8bd5\u5b58\u50a8\u5230\u672c\u5730\u8def\u5f84" + this.tempPath + "\u4e0b", (Throwable)throwException);
        return this.storeTemp(remote, content);
    }

    private boolean makeDirectorys(FTPClient ftpclient, String remote) throws Exception {
        File file = new File(remote);
        if (file.getPath().indexOf(File.separator) == -1) {
            ftpclient.makeDirectory(file.getPath());
        } else {
            this.makeDirectorys(ftpclient, file.getParent());
            ftpclient.makeDirectory(file.getPath());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeTemp(String remote, InputStream local) {
        FileOutputStream fos = null;
        try {
            File file = new File(this.tempPath, remote);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            int bytesWritten = 0;
            int byteCount = 0;
            byte[] bytes = new byte[1024];
            while ((byteCount = local.read(bytes)) != -1) {
                fos.write(bytes, bytesWritten, byteCount);
                bytesWritten += byteCount;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("\u5b58\u50a8\u5230\u672c\u5730\u8def\u5f84" + this.tempPath + "\u4e0b\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (local != null) {
                    local.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeTemp(String remote, byte[] content) {
        FileOutputStream fos = null;
        try {
            File file = new File(this.tempPath, remote);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            fos.write(content);
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("\u5b58\u50a8\u5230\u672c\u5730\u8def\u5f84" + this.tempPath + "\u4e0b\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(FileInputStream fileInput) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = -1;
        InputStream inputStream = null;
        try {
            while ((n = fileInput.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
            byte[] byteArray = baos.toByteArray();
            InputStream inputStream2 = inputStream = new ByteArrayInputStream(byteArray);
            return inputStream2;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            InputStream inputStream3 = null;
            return inputStream3;
        }
        catch (IOException e) {
            e.printStackTrace();
            InputStream inputStream4 = null;
            return inputStream4;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getParentPath(String remote) {
        File f = new File(remote);
        return f.getParent();
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public void setTempPath(String tempPath) {
        this.tempPath = tempPath;
    }
}

