package com.viontech.keliu.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.util.SpringContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArraySet;

@ServerEndpoint(value = "/webSocket/log")
@Component
public class LogWebSocket {
	private String serialnum;

    private Logger logger = LoggerFactory.getLogger(LogWebSocket.class);
    //concurrent包的线程安全Set，用来存放每个客户端对应的MyWebSocket对象。
    private static CopyOnWriteArraySet<LogWebSocket> webSocketSet = new CopyOnWriteArraySet<LogWebSocket>();

    //与某个客户端的连接会话，需要通过它来给客户端发送数据
    private Session session;

    public LogWebSocket() {
		super();
	}

	/**
     * 连接建立成功调用的方法*/
    @OnOpen
    public void onOpen(Session session,@PathParam("serialnum")String serialnum) {
    	this.serialnum = serialnum;
        this.session = session;
        webSocketSet.add(this);     //加入set中

    }

    /**
     * 连接关闭调用的方法
     */
    @OnClose
    public void onClose() {
        webSocketSet.remove(this);  //从set中删除
    }

    /**
     * 收到客户端消息后调用的方法
     *
     * @param message 客户端发送过来的消息*/
    @OnMessage
    public void onMessage(String message, Session session) {
    	
    }

    /**
     * 发生错误时调用
     * */
    @OnError
    public void onError(Session session, Throwable error) {
        logger.debug("发生错误");
        error.printStackTrace();
    }


    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }
    public void sendMessage(Object message) throws IOException {
    	ObjectMapper objectMapper = (ObjectMapper) SpringContextUtils.getBean("objectMapper");
    	String messageStr = objectMapper.writeValueAsString(message);
       this.sendMessage(messageStr);
    }


    /**
     * 群发自定义消息
     * */
    public static void sendInfo(String serialnum,Object message) throws IOException {
        for (LogWebSocket item : webSocketSet) {
            try {
            	if(item.isNeedSend(serialnum)){
            		item.sendMessage(message);
            	}
            } catch (IOException e) {
                continue;
            }
        }
    }
    /**
     * 群发自定义消息
     * */
    public static void sendInfo(Object message) throws IOException {
    	sendInfo(null, message);
    }
    
    public boolean isNeedSend(String serialnum){
    	if(this.serialnum == null || serialnum == null){
    		return true;
    	}
    	if(this.serialnum.equals(serialnum)){
    		return true;
    	}
    	return false;
    }

   
}