package com.viontech.keliu.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;
 
public class YuvToRGB {

	public static int  Yuv420PSUVtoRGB32(byte[] srcY, byte[] srcUV, int[] destARGB, int width, int height){
		byte[] u = new byte[srcUV.length/2];
		byte[] v = new byte[srcUV.length/2];
		int index =0;
		for (int i=0;i < srcUV.length;){
			v[index] = srcUV[i++];
			u[index] = srcUV[i++];
			index++;
		}
		return YUV420toRGB32(srcY,u,v,destARGB,width,height);
	}

	public static int YUV420toRGB32(byte[] srcY, byte[] srcU, byte[] srcV, int[] destARGB, int width, int height) {
		   int wrap, x, y, pyID, destID, puvID, destID_1,tmp;
		   int sy, su, sv;

		   wrap = width;
		   pyID = 0;
		   destID = 0;
		   destID_1 = 0;
		   puvID = 0;
		   tmp = 0;

		   for (y = 0; y < height; y += 2) {
		    for (x = 0; x < width; x += 2) {
		     sy = srcY[pyID] >= 0 ? srcY[pyID] : srcY[pyID] + 256;
		     su = srcU[puvID] >= 0 ? srcU[puvID] : srcU[puvID] + 256;
		     sv = srcV[puvID] >= 0 ? srcV[puvID] : srcV[puvID] + 256;
		    
		     destARGB[destID] = 0;
		     tmp = (int) ((298 * (sy - 16) + 409 * (sv - 128) + 128) >> 8);
		     destARGB[destID] = (destARGB[destID] | (tmp < 256 ? (tmp>0?tmp:0) : 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) - 100 * (su - 128) - 208 * (sv - 128) + 128) >> 8);
		     destARGB[destID] = (destARGB[destID] | (tmp < 256 ? (tmp>0?tmp:0): 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) + 516 * (su - 128) + 128) >> 8);
		     destARGB[destID] = (destARGB[destID] | (tmp < 256 ? (tmp>0?tmp:0): 255));

		     sy = srcY[pyID + 1] >= 0 ? srcY[pyID + 1] : srcY[pyID + 1] + 256;

		     destID_1 = destID + 1;
		    
		     destARGB[destID_1] = 0;
		     tmp = (int) ((298 * (sy - 16) + 409 * (sv - 128) + 128) >> 8);
		     destARGB[destID_1] = (destARGB[destID_1] | (tmp < 256 ? (tmp>0?tmp:0): 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) - 100 * (su - 128) - 208 * (sv - 128) + 128) >> 8);
		     destARGB[destID_1] = (destARGB[destID_1] | (tmp < 256 ? (tmp>0?tmp:0): 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) + 516 * (su - 128) + 128) >> 8);
		     destARGB[destID_1] = (destARGB[destID_1] | (tmp < 256 ? (tmp>0?tmp:0): 255));

		     pyID += wrap;
		     destID += wrap;

		     sy = srcY[pyID] >= 0 ? srcY[pyID] : srcY[pyID] + 256;

		     destARGB[destID] = 0;
		     tmp = (int) ((298 * (sy - 16) + 409 * (sv - 128) + 128) >> 8);
		     destARGB[destID] = (destARGB[destID] | (tmp < 256 ? (tmp>0?tmp:0): 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) - 100 * (su - 128) - 208 * (sv - 128) + 128) >> 8);
		     destARGB[destID] = (destARGB[destID] | (tmp < 256 ? (tmp>0?tmp:0): 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) + 516 * (su - 128) + 128) >> 8);
		     destARGB[destID] = (destARGB[destID] | (tmp < 256 ? (tmp>0?tmp:0): 255));

		     sy = srcY[pyID + 1] >= 0 ? srcY[pyID + 1] : srcY[pyID + 1] + 256;

		     destID_1 = destID + 1;
		    
		     destARGB[destID_1] = 0;
		     tmp = (int) ((298 * (sy - 16) + 409 * (sv - 128) + 128) >> 8);
		     destARGB[destID_1] = (destARGB[destID_1] | (tmp < 256 ? (tmp>0?tmp:0): 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) - 100 * (su - 128) - 208 * (sv - 128) + 128) >> 8);
		     destARGB[destID_1] = (destARGB[destID_1] | (tmp < 256 ? (tmp>0?tmp:0): 255)) << 8;
		    
		     tmp = (int) ((298 * (sy - 16) + 516 * (su - 128) + 128) >> 8);
		     destARGB[destID_1] = (destARGB[destID_1] | (tmp < 256 ? (tmp>0?tmp:0): 255));

		     pyID += (-wrap + 2);
		     destID += (-wrap + 2);
		     puvID++;
		    }
		    pyID += wrap;
		    destID += wrap;
		   }
		   return 0;
		}
		public static BufferedImage Yuv420ToImage(byte[] srcY, byte[] srcU, byte[] srcV, int width, int height){
			int[] destARGB = new  int[width*height];
			YUV420toRGB32(srcY, srcU, srcV, destARGB, width, height);
			BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
			bufferedImage.setRGB(0, 0, width, height, destARGB, 0, width);
			return bufferedImage;
		
		}
	public static BufferedImage Yuv420PSUVToImage(byte[] srcY, byte[] srcUV, int width, int height){
		int[] destARGB = new  int[width*height];
		Yuv420PSUVtoRGB32(srcY, srcUV, destARGB, width, height);
		BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		bufferedImage.setRGB(0, 0, width, height, destARGB, 0, width);
		return bufferedImage;

	}
		
		public static void yuvToImageFile(String filePath,String fileName,byte[] srcY, byte[] srcU, byte[] srcV, int width, int height){
			OutputStream output = null;
			try {
				BufferedImage image = Yuv420ToImage(srcY, srcU, srcV, width, height);
				output = new FileOutputStream(new File(filePath,fileName));
				ImageIO.write(image, "jpg", output);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}finally{
			}
		}
		
		
			

}
