package com.viontech.keliu.storage;

import com.viontech.keliu.oss.OssClientHelper;

/**
 * @author 谢明辉
 * @createDate 2018-10-27
 * @description
 */

public class OssFeatureStorage extends PathStorage<String> {

    private OssClientHelper ossClientHelper;

    @Override
    public void setItem(String key, String item) {
        try {
            ossClientHelper.storeFile(storagePathGenerator.generator(key), item.getBytes());
        } catch (Exception e) {
           // e.printStackTrace();
        }
    }

    @Override
    public String getItem(String key) {
        try {
            return ossClientHelper.getItem(storagePathGenerator.generator(key));
        } catch(Exception e) {
           // e.printStackTrace();
        }
        return null;
    }


    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return ossClientHelper.getByteArray(storagePathGenerator.generator(key));
        } catch(Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    public OssClientHelper getOssClientHelper() {
        return ossClientHelper;
    }

    public void setOssClientHelper(OssClientHelper ossClientHelper) {
        this.ossClientHelper = ossClientHelper;
    }

}
