package com.viontech.keliu.storage;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;

public class LocalImageStorage extends PathStorage<BufferedImage>{
	private String basePath;

	@Override
	public void setItem(String key, BufferedImage item) {
		OutputStream output = null;
		try {
			File file = new File(basePath,storagePathGenerator.generator(key));
			if(!file.getParentFile().exists()){
				file.getParentFile().mkdirs();
			}
			output = new FileOutputStream(file);
			ImageIO.write(item, "jpg", output);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(output != null){
				try {
					output.flush();
					output.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	@Override
	public BufferedImage getItem(String key) {
		try {
			File file = new File(basePath,storagePathGenerator.generator(key));
			if(!file.exists()){
				return null;
			}
			if(!file.getParentFile().exists()){
				file.getParentFile().mkdirs();
			}
			return ImageIO.read(file);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{

		}
		return null;
	}

	@Override
	public byte[] getByteArrayItem(String key) {
		try {
			File file = new File(basePath,storagePathGenerator.generator(key));
			if(!file.getParentFile().exists()){
				file.getParentFile().mkdirs();
			}
			return readFile(file);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{

		}
		return null;
	}

	public String getBasePath() {
		return basePath;
	}

	public void setBasePath(String basePath) {
		this.basePath = basePath;
	}
}
