package com.viontech.keliu.storage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class LocalFeatureStorage extends PathStorage<String> {
    private String basePath;
    private final Logger logger  = LoggerFactory.getLogger(LocalFeatureStorage.class);
    @Override
    public void setItem(String key, String item) {
        FileOutputStream fos = null;
        try {
            File file = new File(basePath, storagePathGenerator.generator(key));


            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            int jsonLength = item.length();
            byte[] jsonBytes = item.getBytes();
            fos.write(jsonBytes, 0, jsonLength);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }

            }
        }
    }


    @Override
    public String getItem(String key) {
        String json = getJsonArrayItem(key);
        if (json == null) {
            return null;
        }
        return json;
    }


    @Override
    public byte[] getByteArrayItem(String key) {
        File file = new File(basePath, storagePathGenerator.generator(key));
        try {
            return readFile(file);
        } catch (IOException e) {
            logger.error("getByteArrayItem",e);
            e.printStackTrace();
        }
        return null;
    }

    public String getJsonArrayItem(String key) {
        File file = new File(basePath, storagePathGenerator.generator(key));
        logger.info("开始获取特征"+file.getAbsolutePath());
        try {
            String s = readFile2Json(file);
            return s;
        } catch (IOException e) {
            logger.info("特征获取失败"+file.getAbsolutePath());
            e.printStackTrace();
        }
        return null;
    }

    public String getBasePath() {
        return basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}
