package com.viontech.keliu.storage;

import com.viontech.keliu.ftp.FTPClientHelper;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;

public class FtpImageStorage extends PathStorage<BufferedImage>{
	private FTPClientHelper ftpClientHelper;

	@Override
	public void setItem(String key, BufferedImage item) {
		ByteArrayOutputStream outputStream = null;
		try {
			outputStream =  new ByteArrayOutputStream();
			ImageIO.write(item, "jpg", outputStream);
			byte[] bytes = outputStream.toByteArray();
			ftpClientHelper.storeFile(storagePathGenerator.generator(key),bytes);

		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} finally{
			try {
				if(outputStream != null){
					outputStream.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public BufferedImage getItem(String key) {
		try {
			byte[] bytes = ftpClientHelper.retrieveFileStream(storagePathGenerator.generator(key));
			ByteArrayInputStream in = new ByteArrayInputStream(bytes);    //将b作为输入流；
			BufferedImage image = ImageIO.read(in);     //将in作为输入流，读取图片存入image中，而这里in可以为ByteArrayInputStream();
			return image;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public byte[] getByteArrayItem(String key) {
		try {
			byte[] bytes = ftpClientHelper.retrieveFileStream(storagePathGenerator.generator(key));
			return bytes;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public FTPClientHelper getFtpClientHelper() {
		return ftpClientHelper;
	}

	public void setFtpClientHelper(FTPClientHelper ftpClientHelper) {
		this.ftpClientHelper = ftpClientHelper;
	}
}
