package com.viontech.keliu.storage;

import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.redis.KryoRedisSerializer;

public class FtpFeatureStorage extends PathStorage<String> {
    KryoRedisSerializer kryo = new KryoRedisSerializer();
    private FTPClientHelper ftpClientHelper;

    @Override
    public void setItem(String key, String item) {
        try {
            ftpClientHelper.storeFile(storagePathGenerator.generator(key), item.getBytes());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getItem(String key) {
        return this.getByteArrayItem(key).toString();
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        return ftpClientHelper.retrieveFileStream(storagePathGenerator.generator(key));
    }

    public FTPClientHelper getFtpClientHelper() {
        return ftpClientHelper;
    }

    public void setFtpClientHelper(FTPClientHelper ftpClientHelper) {
        this.ftpClientHelper = ftpClientHelper;
    }
}
