package com.viontech.keliu.model;

import java.util.Date;

public class CountDataContent extends Content{
	private String vasid;
	private String channelno;
	private int innum;
	private int outnum;
	private Date createTime;
	private Date countdate;
	private Integer status;
	private Long gateId;
	private Long mallId;
	private boolean isRepeat = false;

	public Date getCountdate() {
		return createTime;
	}
	public Integer getStatus() {
		if(status==null){
			status=0;
		}
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public CountDataContent() {
		super();
	}

	@Override
	public boolean isNeedResponse() {
		return true;
	}

	public String getVasid() {
		return vasid;
	}

	public void setVasid(String vasid) {
		this.vasid = vasid;
	}

	public String getChannelno() {
		try {
			StringBuilder sb = new StringBuilder();
			sb.append(vasid).append("-");
			int channelnoInt = Integer.parseInt(channelno);
			channelnoInt += 1;
			if (channelnoInt < 10) {
				sb.append("0");
			}
			sb.append(channelnoInt);
			return sb.toString();
		}catch (Exception e){
			return channelno;
		}
	}

	public void setChannelno(String channelno) {
		this.channelno = channelno;
	}

	public int getInnum() {
		return innum;
	}

	public void setInnum(int innum) {
		this.innum = innum;
	}

	public int getOutnum() {
		return outnum;
	}

	public void setOutnum(int outnum) {
		this.outnum = outnum;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}



	public Long getGateId() {
		return gateId;
	}

	public void setGateId(Long gateId) {
		this.gateId = gateId;
	}

	public boolean isRepeat() {
		return isRepeat;
	}

	public void setRepeat(boolean repeat) {
		isRepeat = repeat;
	}

	@Override
	public String toString() {
		return "{" +
				"vasid='" + vasid + '\'' +
				", channelno='" + channelno + '\'' +
				", innum=" + innum +
				", outnum=" + outnum +
				", createTime=" + createTime +
				", countdate=" + countdate +
				", status=" + status +
				'}';
	}

	public Long getMallId() {
		return mallId;
	}

	public void setMallId(Long mallId) {
		this.mallId = mallId;
	}
}
