/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.task;

import com.viontech.keliu.util.JsonMessageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Component
@ConditionalOnProperty(name={"vion.task"}, havingValue="1")
public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    @Resource
    private JdbcTemplate template;
    @Value(value="${vion.task.target}")
    private String target;
    @Autowired
    private RestTemplateBuilder restTemplateBuilder;

    @Scheduled(cron="${vion.task.cron}")
    @Transactional(rollbackFor={Exception.class})
    public void task() {
        RestTemplate restTemplate = this.restTemplateBuilder.build();
        JsonMessageUtil.JsonMessage formatMessage = (JsonMessageUtil.JsonMessage)restTemplate.getForObject(this.target + "format", JsonMessageUtil.JsonMessage.class, new Object[0]);
        List formats = (List)formatMessage.getData();
        JsonMessageUtil.JsonMessage subFormatMessage = (JsonMessageUtil.JsonMessage)restTemplate.getForObject(this.target + "subFormat", JsonMessageUtil.JsonMessage.class, new Object[0]);
        List subFormats = (List)subFormatMessage.getData();
        String sqlClear = "delete from b_format";
        String sqlClearSub = "delete from b_sub_format";
        this.template.update(sqlClear);
        this.template.update(sqlClearSub);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.template);
        SqlParameterSource[] formatsBatch = SqlParameterSourceUtils.createBatch((Collection)formats);
        String sqlInsertFormat = "insert into b_format(id,unid,name) values (:id,:unid,:name)";
        namedParameterJdbcTemplate.batchUpdate(sqlInsertFormat, formatsBatch);
        SqlParameterSource[] subFormatsBatch = SqlParameterSourceUtils.createBatch((Collection)subFormats);
        String sqlInsertSubFormat = "insert into b_sub_format(id,unid,name,format_id,format_unid) values(:id,:unid,:name,:formatId,:formatUnid)";
        namedParameterJdbcTemplate.batchUpdate(sqlInsertSubFormat, subFormatsBatch);
        log.info("\u66f4\u65b0\u6210\u529f");
    }
}

