/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.repository;

import com.viontech.keliu.entity.SubFormat;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class SubFormatRepository {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private static final BeanPropertyRowMapper<SubFormat> RETAIL_FORMAT_CHILD_BEAN_PROPERTY_ROW_MAPPER = new BeanPropertyRowMapper(SubFormat.class);
    private static final String SQL_SELECT_ALL = "select * from b_sub_format ";
    private static final String SQL_INSERT = "insert into b_sub_format (name,format_id,format_unid) values(?,?,?) ";
    private static final String SQL_DELETE_PRE = "DELETE from b_sub_format ";
    private static final String SQL_UPDATE_PRE = "UPDATE b_sub_format set ";

    public List<SubFormat> selectAll() {
        return this.jdbcTemplate.query(SQL_SELECT_ALL, (RowMapper)RETAIL_FORMAT_CHILD_BEAN_PROPERTY_ROW_MAPPER);
    }

    public List<SubFormat> selectBy(SubFormat item) {
        LinkedList<Object> paramList = new LinkedList<Object>();
        StringBuilder sb = new StringBuilder(SQL_SELECT_ALL).append(" where ");
        this.idAndUnidCondition(item, paramList, sb);
        if (item.getFormatId() != null) {
            sb.append(" and format_id=? ");
            paramList.add(item.getFormatId());
        }
        if (item.getFormatUnid() != null) {
            sb.append(" and format_unid=? ");
            paramList.add(item.getFormatUnid());
        }
        String sql = sb.toString().replaceFirst("and", "");
        return this.jdbcTemplate.query(sql, paramList.toArray(), (RowMapper)RETAIL_FORMAT_CHILD_BEAN_PROPERTY_ROW_MAPPER);
    }

    public int insert(SubFormat item) {
        return this.jdbcTemplate.update(SQL_INSERT, new Object[]{item.getName(), item.getFormatId(), item.getFormatUnid()});
    }

    public int delete(SubFormat item) {
        LinkedList paramList = new LinkedList();
        StringBuilder sb = new StringBuilder(SQL_DELETE_PRE).append(" where ");
        this.idAndUnidCondition(item, paramList, sb);
        String sql = sb.toString().replaceFirst("and", "");
        return this.jdbcTemplate.update(sql, paramList.toArray());
    }

    public int deleteByFormatId(Integer formatId) {
        String sql = "delete from b_sub_format where format_id=?";
        return this.jdbcTemplate.update(sql, new Object[]{formatId});
    }

    public int update(SubFormat item) {
        LinkedList<Object> paramList = new LinkedList<Object>();
        StringBuilder sb = new StringBuilder(SQL_UPDATE_PRE);
        if (item.getName() != null) {
            sb.append(" ,name=?");
            paramList.add(item.getName());
        }
        if (item.getFormatId() != null) {
            sb.append(" ,format_id=?");
            paramList.add(item.getFormatId());
        }
        if (item.getFormatUnid() != null) {
            sb.append(" ,format_unid=?");
            paramList.add(item.getFormatUnid());
        }
        sb.append(" where ");
        this.idAndUnidCondition(item, paramList, sb);
        String sql = sb.toString().replaceFirst("and", "").replaceFirst(",", "");
        return this.jdbcTemplate.update(sql, paramList.toArray());
    }

    public void idAndUnidCondition(SubFormat item, LinkedList<Object> paramList, StringBuilder sb) {
        if (item.getId() != null) {
            sb.append(" and id=? ");
            paramList.add(item.getId());
        }
        if (item.getUnid() != null) {
            sb.append(" and unid=? ");
            paramList.add(item.getUnid());
        }
    }
}

