/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.repository;

import com.viontech.keliu.entity.Format;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class FormatRepository {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private static final BeanPropertyRowMapper<Format> RETAIL_FORMAT_BEAN_PROPERTY_ROW_MAPPER = new BeanPropertyRowMapper(Format.class);
    private static final String SQL_SELECT_ALL = "select * from b_format ";
    private static final String SQL_INSERT = "insert into b_format (name) values(?) ";
    private static final String SQL_DELETE_PRE = "DELETE from b_format ";
    private static final String SQL_UPDATE_PRE = "UPDATE b_format set name=? ";

    public List<Format> selectBy(Format item) {
        LinkedList<Object> paramList = new LinkedList<Object>();
        StringBuilder sb = new StringBuilder(SQL_SELECT_ALL).append(" where ");
        if (item.getId() != null) {
            sb.append(" and id=?");
            paramList.add(item.getId());
        }
        if (item.getUnid() != null) {
            sb.append(" and unid=?");
            paramList.add(item.getUnid());
        }
        if (item.getName() != null) {
            sb.append(" and name=?");
            paramList.add(item.getName());
        }
        String sql = sb.toString().replaceFirst("and", "");
        return this.jdbcTemplate.query(sql, paramList.toArray(), (RowMapper)RETAIL_FORMAT_BEAN_PROPERTY_ROW_MAPPER);
    }

    public List<Format> selectAll() {
        return this.jdbcTemplate.query(SQL_SELECT_ALL, (RowMapper)RETAIL_FORMAT_BEAN_PROPERTY_ROW_MAPPER);
    }

    public int insert(Format format) {
        return this.jdbcTemplate.update(SQL_INSERT, new Object[]{format.getName()});
    }

    public int delete(Format item) {
        StringBuilder sb = new StringBuilder(SQL_DELETE_PRE).append(" where ");
        LinkedList paramList = new LinkedList();
        return this.idAndUnidCondition(item, sb, paramList);
    }

    public int update(Format item) {
        if (item.getName() == null) {
            return 0;
        }
        StringBuilder sb = new StringBuilder(SQL_UPDATE_PRE);
        LinkedList<String> paramList = new LinkedList<String>();
        paramList.add(item.getName());
        sb.append(" where ");
        return this.idAndUnidCondition(item, sb, paramList);
    }

    public int idAndUnidCondition(Format item, StringBuilder sb, LinkedList<Object> paramList) {
        if (item.getId() != null) {
            sb.append(" and id=? ");
            paramList.add(item.getId());
        }
        if (item.getUnid() != null) {
            sb.append(" and unid=? ");
            paramList.add(item.getUnid());
        }
        String sql = sb.toString().replaceFirst("and", "");
        return this.jdbcTemplate.update(sql, paramList.toArray());
    }
}

