package com.viontech.keliu.utils;


import com.viontech.keliu.entity.Operate;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;


/**
 * @author 谢明辉
 * @createDate 2019-2-28
 * @description
 */

public class Utils {

    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private static final String FULL_TIME = "\\[(.+?)\\]\\s?\\[(.+?)\\]\\s?\\[(.+?)\\]\\sContent:(.+)";
    private static final Pattern FULL_TIME_PATTERN = Pattern.compile(FULL_TIME);

    /**
     * 解压tar文件
     *
     * @param file      要解压的tar文件对象
     * @param outputDir 要解压到某个指定的目录下
     * @throws IOException
     */
    public static List<File> unTarGz(File file, String outputDir) throws IOException {
        List<File> files = new ArrayList<>();
        String fullName = file.getName();
        String name = fullName.substring(0, fullName.indexOf("."));
        TarInputStream tarIn = null;
        try {
            //             三代机的日志压缩包没有经过gzip压缩，其他设备的经过gzip压缩         可以改成去掉“T20_”try catch 里面处理

            try {
                tarIn = new TarInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)), 1024 * 2));
            } catch (Exception e) {
                tarIn = new TarInputStream((new BufferedInputStream(new FileInputStream(file))), 1024 * 2);
            }

            createDirectory(outputDir, null);

            TarEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                if (!entry.isDirectory() && (entry.getName().contains("VionCount.log") || entry.getName().contains("Operation.log"))) {
                    String[] names = entry.getName().split("/");
                    File tmpFile = new File(outputDir + "/" + name + names[names.length - 1]);
                    //                    创建输出目录
                    createDirectory(tmpFile.getParent() + "/", null);
                    OutputStream out = null;
                    try {
                        out = new FileOutputStream(tmpFile);
                        int length;

                        byte[] b = new byte[2048];

                        while ((length = tarIn.read(b)) != -1) {
                            out.write(b, 0, length);
                        }


                    } catch (IOException ex) {
                        log.error(Utils.getExceptionInfo(ex));
                        throw ex;
                    } finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                    files.add(tmpFile);
                }
            }
        } catch (IOException ex) {
            log.error(getExceptionInfo(ex));
            throw new IOException("解压归档文件出现异常", ex);
        } finally {
            try {
                if (tarIn != null) {
                    tarIn.close();
                }
            } catch (IOException ex) {
                log.error(getExceptionInfo(ex));
            }
        }
        return files;
    }

    /**
     * 构建目录
     *
     * @param outputDir
     * @param subDir
     */
    private static void createDirectory(String outputDir, String subDir) {
        File file = new File(outputDir);
        //        判断子目录是否为空
        if (!(subDir == null || "".equals(subDir.trim()))) {
            file = new File(outputDir + "/" + subDir);
        }
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.mkdirs();
        }
    }

    /**
     * 通过日志行信息拿到所需要的操作
     *
     * @param line 需要解析的日志行
     * @return com.viontech.keliu.entity.Operate
     * @createDate 2019-4-3
     */
    private static Operate getOperate(String line) throws ParseException {
        Operate operate = new Operate();
        Matcher matcher = FULL_TIME_PATTERN.matcher(line);
        if (matcher.find()) {
            operate.setOperateTime(getDateTime(matcher.group(2)));
            operate.setOperateDate(getDate(matcher.group(2)));
            operate.setType(matcher.group(3));
            operate.setOperate(matcher.group(4));
        }
        return operate;
    }

    /**
     * 分析日志文件
     *
     * @param files 需要分析的日志文件
     * @return java.util.List<com.viontech.keliu.entity.Operate> 返回操作列表
     * @createDate 2019-4-3
     */
    public static List<Operate> analyseLogFiles(List<File> files) {
        List<Operate> operates = new ArrayList<>();
        for (File file : files) {
            try {

                // operation日志需要设置
                boolean flag = file.getName().contains("Operation");
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file), "utf8"));
                String line;
                while ((line = br.readLine()) != null) {
                    log.debug(line);
                    try {
                        Operate operate = Utils.getOperate(line);
                        if (flag) {
                            operate.setType("OperationLog");
                        }
                        operates.add(operate);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                br.close();
            } catch (Exception e) {
                log.error(Utils.getExceptionInfo(e));
            }

        }
        return operates;
    }

    public static Date getDateTime(String dateStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(dateStr);
    }

    public static Date getDate(String dateStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(dateStr);
    }

    /**
     * 获取exception的异常信息
     *
     * @param e exception
     * @return java.lang.String
     * @createDate 2019-4-3
     */
    public static String getExceptionInfo(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String s = sw.toString();
        sw.flush();
        try {
            sw.close();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        pw.close();
        return s;
    }

}
