package com.viontech.keliu.service.impl;


import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.constant.URLConstant;
import com.viontech.keliu.http.HttpMethodName;
import com.viontech.keliu.http.VionHttpClient;
import com.viontech.keliu.http.VionRequest;
import com.viontech.keliu.http.VionResponse;
import com.viontech.keliu.service.adapter.DeviceLogDownloadService;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;


/**
 * Created by 苏曼 on 2019/2/26.
 */
@Service
public class DeviceLogDownloadServiceImpl implements DeviceLogDownloadService {

    Random random = new Random();
    @Autowired
    ObjectMapper objectMapper;

    @Override
    public String buildLogFile(String host, int port, boolean systemLog, boolean dogLog, boolean operLog, Date date) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String buildLogUrl = MessageFormat.format(URLConstant.URL_BUILD_LOG, host, port);
        VionRequest vionRequest = new VionRequest();
        vionRequest.setUri(buildLogUrl);
        vionRequest.setHttpMethod(HttpMethodName.GET);
        HashMap<String, String> requestMap = new HashMap<>();
        requestMap.put("systemlog", "1");
        requestMap.put("doglog", "1");
        requestMap.put("operlog", "1");
        requestMap.put("starttime", sdf.format(date));
        requestMap.put("endtime", sdf.format(date));
        requestMap.put("_t", String.valueOf(random.nextLong()));
        vionRequest.setParams(requestMap);
        VionResponse response = VionHttpClient.post(vionRequest);
        String body = response.getBodyStr();
        JSONObject jsonObject = new JSONObject(body);
        return jsonObject.getString("download");
    }

    /**
     * 得到日志压缩文件
     * @param host 目标主机
     * @param port 目标主机的端口
     * @param deviceSerialnum 设备序列号
     * @param date 下载的日志的时间
     * @param logFileName 下载的日志文件名称
     * @param savePath 保存日志文件的路径
     * @return java.lang.String 返回空或者保存的日志压缩文件的名称
     * @createDate 2019-3-11
     */
    @Override
    public File downloadLog(String host, int port, String deviceSerialnum, Date date, String logFileName, String savePath) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String buildLogUrl = MessageFormat.format(URLConstant.URL_DOWNLOAD_LOG, host, port, logFileName);
        VionRequest vionRequest = new VionRequest();
        vionRequest.setUri(buildLogUrl);
        vionRequest.setHttpMethod(HttpMethodName.GET);
        VionResponse response = VionHttpClient.post(vionRequest);
        byte[] body = response.getBody();

        // 若果没有数据就返回空
        if (body == null || body.length <= 0) {
            return null;
        }

        File file = new File(savePath, deviceSerialnum + "_" + sdf.format(date) + ".tar.gz");
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(body);
        fos.close();
        return file;
    }
}
