package com.viontech.keliu.runner;


import com.viontech.keliu.constant.URLConstant;
import com.viontech.keliu.dao.DeviceDao;
import com.viontech.keliu.entity.DeviceDetails;
import com.viontech.keliu.entity.Operate;
import com.viontech.keliu.service.adapter.DeviceLogDownloadService;
import com.viontech.keliu.utils.HttpClient;
import com.viontech.keliu.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;


/**
 * Created by 苏曼 on 2019/2/26.
 */
@Component
@ConditionalOnProperty(name = "target")
public class DownLoadRunner {

    private static final Logger log = LoggerFactory.getLogger(DownLoadRunner.class);


    @Resource
    private DeviceDao deviceDao;

    @Autowired
    private DeviceLogDownloadService deviceLogDownloadService;
    @Value("${savePath:D:\\deviceLog}")
    private String savePath;
    @Value("${target}")
    private String target;


    @Scheduled(cron = "0 0 10 * * ? ")
    //    @Scheduled(fixedDelay = 1000 * 60 * 120L, initialDelay = 2000L)
    public void run() throws Exception {
        Date endtime = new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1));
        log.info("running------------" + endtime.toString());

        List<DeviceDetails> deviceDetails = deviceDao.getDeviceDetails();
        for (DeviceDetails item : deviceDetails) {

            String serialNum = item.getDeviceSerialNum();

            try {

                String string = deviceLogDownloadService.buildLogFile(item.getDeviceIP(), 80, true, true, true, endtime);
                File tarGz = deviceLogDownloadService.downloadLog(item.getDeviceIP(), 80, serialNum, endtime, string, savePath);
                if (tarGz != null) {
                    List<File> logs = Utils.unTarGz(tarGz, savePath);
                    List<Operate> operates = Utils.analyseLogFiles(logs);
                    item.setOperateList(operates);
                } else {
                    log.error("日志文件不存在-{}-{}", serialNum, endtime);
                }

            } catch (Exception e) {
                log.error(Utils.getExceptionInfo(e));
            }
        }

        sendLog(deviceDetails);

    }


    /**
     * @param deviceDetails 需要发送的设备日志详细信息
     * @createDate 2019-3-11
     */
    private void sendLog(List<DeviceDetails> deviceDetails) throws IOException {
        log.info("------------------------------------开始发送日志信息------------------------------------------------");
        HashMap requestMap = new HashMap<>();

        requestMap.put("data", deviceDetails);

        HashMap response = new HttpClient<HashMap>(MessageFormat.format(URLConstant.URL_SEND_LOG, target, "9000"))
                           .jsonType()
                           .post(requestMap, HashMap.class);
        if ((Integer) response.get("code") == 200) {
            log.info("-------------------发送成功----------------------");
        } else {
            log.error("------------------发送失败:{}----------------------", response.get("info"));
        }
    }
}
