package com.viontech.keliu.entity;


import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.ArrayList;
import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2019-3-20
 * @description
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Options {

    private String label;
    private String value;
    private List<Options> children;

    public Options(String value, String label) {
        this.label = label;
        this.value = value;
    }

    public Options() {
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<Options> getChildren() {
        return children;
    }

    public void setChildren(List<Options> children) {
        this.children = children;
    }

    public void addChildren(Options options) {
        if (children == null) {
            children = new ArrayList<>();
        }
        children.add(options);
    }

}
