package com.viontech.keliu.controller;


import com.viontech.keliu.dao.DeviceDao;
import com.viontech.keliu.entity.DeviceDetails;
import com.viontech.keliu.entity.Options;
import com.viontech.keliu.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.websocket.server.PathParam;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author 谢明辉
 * @createDate 2019-3-11
 * @description
 */
@RestController
public class LogController {

    private static final Logger log = LoggerFactory.getLogger(LogController.class);


    private static List<Options> OPTIONS = null;
    private static Long TIME = null;

    @Resource
    private DeviceDao dao;

    @PostMapping("/device/logs")
    public Object deviceLog(@RequestBody HashMap<String, List<DeviceDetails>> map) throws IOException {
        try {
            List<DeviceDetails> deviceLog = map.get("data");
            for (DeviceDetails dd : deviceLog) {

                // 得到广场列表
                Map<String, Long> mallMap = dao.getMallMap();
                // 得到监控点列表
                Map<String, Long> gateMap = dao.getGateMap();
                // 验证
                Long mallId;
                Long gateId;
                if ((mallId = mallMap.get(dd.getMallUnid())) != null && (gateId = gateMap.get(dd.getGateUnid())) != null) {

                    dd.setMallId(mallId);
                    dd.setGateId(gateId);
                    dao.insertLogs(dd);

                }
            }
        } catch (Exception e) {
            String error = Utils.getExceptionInfo(e);
            HashMap<String, Object> response = new HashMap<>();
            log.error(error);
            response.put("info", error);
            response.put("code", 500);
            return response;
        }

        HashMap<String, Object> response = new HashMap<>();
        response.put("info", "上传成功");
        response.put("code", 200);
        return response;
    }

    @GetMapping("/device/logs")
    public Object getDeviceLog(@PathParam("mallId") Long mallId, @PathParam("gateId") Long gateId, @PathParam("deviceSerialNum") String deviceSerialNum, @PathParam("date") String date, @PathParam("type") String type, Integer page) throws ParseException {
        Date d = null;
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            d = sdf.parse(date);
        }
        if (page == null) {
            page = 1;
        }

        Map<String, Object> map = new HashMap<>();
        map.put("total", dao.getLogCount(mallId, gateId, deviceSerialNum, d, type));
        map.put("data", dao.getLogInfo(mallId, gateId, deviceSerialNum, d, type, page));
        return map;
    }

    @GetMapping("/device/mallList")
    public Object getMallList() {


        return dao.getMallList();
    }

    @GetMapping("/device/gateList")
    public Object getGateList(@PathParam("mallId") Long mallId) {

        return dao.getGateList(mallId);
    }


}

