package com.viontech.keliu;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.io.File;


/**
 * Created by 苏曼 on 2019/2/26.
 */
@SpringBootApplication
@EnableScheduling
public class Application implements CommandLineRunner {

    public static void main(String[] args) {
        try {
            SpringApplication.run(Application.class, args);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Value("${savePath:D:\\deviceLog}")
    private String savePath;

    @Override
    public void run(String... strings) throws Exception {
        File file = new File(savePath);
        if (!file.exists()) {
            file.mkdir();
        }
    }
}
