/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.AlgResult;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.websocket.AlgApiClient;
import jakarta.validation.constraints.NotNull;
import jakarta.websocket.DeploymentException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class GeneralPersonApi {
    private final AlgApiClient algApiClient;

    public GeneralPersonApi(AlgApiClient algApiClient) {
        this.algApiClient = algApiClient;
    }

    public CompletableFuture<AlgResult> addPerson(@NotNull String poolId, @NotNull List<Person> people) throws DeploymentException, IOException, ParameterExceptin {
        return this.algApiClient.modifyPersonPool(poolId, 2, 2, people, null);
    }

    public CompletableFuture<AlgResult> deletePerson(@NotNull String poolId, @NotNull List<String> personIds) throws DeploymentException, IOException, ParameterExceptin {
        List<Person> people = personIds.stream().map(x -> {
            Person p = new Person();
            p.setPersonId((String)x);
            return p;
        }).collect(Collectors.toList());
        return this.algApiClient.delPersonPool(0, poolId, people, null);
    }

    public CompletableFuture<AlgResult> updatePerson(@NotNull String poolId, @NotNull Person person) throws DeploymentException, IOException, ParameterExceptin {
        return this.algApiClient.updatePerson(poolId, 2, person, null, Collections.emptyMap());
    }

    public CompletableFuture<AlgResult> updatePerson(@NotNull String poolId, @NotNull Person person, boolean useILMPolicy) throws DeploymentException, IOException, ParameterExceptin {
        return this.algApiClient.updatePerson(poolId, 2, person, null, Collections.emptyMap(), useILMPolicy);
    }

    public CompletableFuture<AlgResult> updateStaff(@NotNull String poolId, @NotNull Person person, boolean useILMPolicy) throws DeploymentException, IOException, ParameterExceptin {
        return this.algApiClient.updateStaff(poolId, person, Collections.emptyMap(), useILMPolicy);
    }
}

