/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.websocket;

import com.alibaba.fastjson.JSON;
import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.AlgResult;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.CaptureRecord;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.FaceKey;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.model.ROI;
import com.viontech.keliu.model.StaffRecord;
import com.viontech.keliu.utils.HttpUtil;
import com.viontech.keliu.utils.UUIDUtil;
import com.viontech.keliu.utils.Util;
import com.viontech.keliu.websocket.GeneralPersonApi;
import com.viontech.keliu.websocket.GeneralPoolApi;
import com.viontech.keliu.websocket.WsClientFacetory;
import jakarta.websocket.DeploymentException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgApiClient {
    public static final String VENDOR_VION = "vion";
    public static final String VENDOR_BAIDU = "baidu";
    public static final String IMAGE_FORMAT_YUV_420I = "YUV_420I";
    public static final String IMAGE_FORMAT_YUV_420SPUV = "YUV_420SPUV";
    public static final String IMAGE_FORMAT_JPG = "jpg";
    public static final String IMAGE_TYPE_FACE = "face";
    public static final String IMAGE_TYPE_BODY = "body";
    private static final Logger log = LoggerFactory.getLogger(AlgApiClient.class);
    public static Map<String, Consumer<AlgResult>> rqid_consumer = new ConcurrentHashMap<String, Consumer<AlgResult>>();
    public final GeneralPoolApi EASY_POOL_API;
    public final GeneralPersonApi EASY_PERSON_API;
    public String urlInfo = "";
    public Boolean httpFlag;
    private WsClientFacetory wsClientFacetory;
    private HttpUtil httpUtil;
    private static final Long TIME_OUT = 0x6DDD00L;

    public AlgApiClient(String url) {
        if (url != null && url.toLowerCase().contains("http")) {
            this.httpFlag = true;
            this.urlInfo = url;
            this.httpUtil = new HttpUtil();
        } else {
            this.httpFlag = false;
            this.wsClientFacetory = new WsClientFacetory();
            this.wsClientFacetory.setUrl(url);
        }
        this.EASY_POOL_API = new GeneralPoolApi(this);
        this.EASY_PERSON_API = new GeneralPersonApi(this);
    }

    private Map<String, Object> getParams(String command, Consumer<AlgResult> callBack) {
        String rid = UUIDUtil.getUUID32();
        rqid_consumer.put(rid, callBack);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", command);
        params.put("rid", rid);
        return params;
    }

    public CompletableFuture<AlgResult> getFeatureAndAttr(String image, String imageType, String imageFormat, List<FaceKey> faceKeys, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        Integer integer;
        ROI roi;
        if (image == null || "".equals(image)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010image\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (imageType == null || "".equals(imageType)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010imageType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (imageFormat == null || "".equals(imageFormat)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010imageFormat\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IMAGE_TYPE_BODY.equals(imageType) && (options == null || options.get("body_roi") == null)) {
            throw new ParameterExceptin("\u5f53ImageType\u4e3aface\u65f6\uff0coptions\u4e2d\u5fc5\u987b\u5305\u542b\u5c5e\u6027\u3010body_roi\u3011");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetFeatureAndAttr", callBack);
        if (!IMAGE_FORMAT_JPG.equals(imageFormat)) {
            Object image_width = options.get("image_width");
            if (image_width == null) {
                throw new ParameterExceptin("\u5b57\u6bb5\u3010image_width\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Object image_height = options.get("image_height");
            if (image_height == null) {
                throw new ParameterExceptin("\u5b57\u6bb5\u3010image_height\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, Object> definition = new HashMap<String, Object>();
            definition.put("width", image_width);
            definition.put("height", image_height);
            params.put("definition", definition);
        }
        String vendor = VENDOR_VION;
        if (options != null && options.get("vendor") != null) {
            vendor = String.valueOf(options.get("vendor"));
        }
        if (options != null && options.get("body_roi") != null) {
            roi = (ROI)options.get("body_roi");
            params.put("bodyROI", roi);
        }
        if (options != null && options.get("face_roi") != null) {
            roi = (ROI)options.get("face_roi");
            params.put("faceROI", roi);
        }
        if (options != null && options.get("needFaceCheck") != null && (integer = (Integer)options.get("needFaceCheck")) == 1) {
            params.put("needFaceCheck", integer);
        }
        params.put("vendor", vendor);
        params.put("image", image);
        params.put("imageType", imageType);
        params.put("imageFormat", imageFormat);
        if (faceKeys != null) {
            float[] faceKeyArr = new float[faceKeys.size() * 2];
            int index = 0;
            for (int i = 0; i < faceKeys.size(); ++i) {
                faceKeyArr[index++] = faceKeys.get(i).getX();
                faceKeyArr[index++] = faceKeys.get(i).getY();
            }
            params.put("faceKeys", faceKeyArr);
        }
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getFaceFeatureBatch(List<String> images, String imageFormat, List<List<FaceKey>> faceKeyLists, List<Map<String, Object>> optionsList) throws ParameterExceptin, IOException, DeploymentException {
        if (Util.isEmpty(imageFormat)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010imageFormat\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (images.size() <= 0) {
            throw new ParameterExceptin("\u53c2\u6570\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        boolean definitionFlag = false;
        if (!IMAGE_FORMAT_JPG.equals(imageFormat)) {
            definitionFlag = true;
            if (images.size() != optionsList.size()) {
                throw new ParameterExceptin("\u53c2\u6570\u957f\u5ea6\u4e0d\u6b63\u786e");
            }
        }
        ArrayList faceImages = new ArrayList();
        for (int i = 0; i < images.size(); ++i) {
            HashMap<String, Object> faceImage = new HashMap<String, Object>(4);
            if (Util.isEmpty(images.get(i))) {
                throw new ParameterExceptin("\u5b57\u6bb5\u3010image\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            faceImage.put("image", images.get(i));
            faceImage.put("imageFormat", imageFormat);
            if (definitionFlag) {
                Object imageWidth = optionsList.get(i).get("image_width");
                Object imageHeight = optionsList.get(i).get("image_height");
                if (imageWidth == null || imageHeight == null) {
                    throw new ParameterExceptin("\u5b57\u6bb5\u3010image_width\u3011\u6216\u3010image_height\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                HashMap<String, Object> definition = new HashMap<String, Object>(2);
                definition.put("width", imageWidth);
                definition.put("height", imageHeight);
                faceImage.put("definition", definition);
            }
            if (faceKeyLists != null && faceKeyLists.size() > 0 && faceKeyLists.get(i) != null) {
                float[] faceKeyArr = new float[faceKeyLists.get(i).size() * 2];
                int index = 0;
                for (int j = 0; j < faceKeyLists.get(i).size(); ++j) {
                    faceKeyArr[index++] = faceKeyLists.get(i).get(j).getX();
                    faceKeyArr[index++] = faceKeyLists.get(i).get(j).getY();
                }
                faceImage.put("faceKeys", faceKeyArr);
            }
            faceImages.add(faceImage);
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetFaceFeatureBatch", callBack);
        params.put("vendor", VENDOR_VION);
        params.put("faceImages", faceImages);
        params.put("ageAndGenderSwitch", 1);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getInTime(List<BodyFeature> bodyFeatures, String outTime, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (bodyFeatures == null || bodyFeatures.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010bodyFeatures\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (outTime == null || outTime == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010outTime\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPool == null) {
            personPool = new ArrayList<Person>();
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetInTime", callBack);
        params.put("bodyFeatures", bodyFeatures);
        params.put("outTime", outTime);
        params.put("personPool", personPool);
        params.put("personPoolId", personPoolId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getAbnormalPerson(String curTime, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (curTime == null || curTime == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010curTime\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPoolId == null || "".equals(personPoolId)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetAbnormalPerson", callBack);
        params.put("curTime", curTime);
        params.put("personPool", personPool);
        params.put("personPoolId", personPoolId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> addPersonPool(String poolId, boolean useILMPolicy, List<Person> personPool) throws IOException, DeploymentException, ParameterExceptin {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("AddPersonPool", callBack);
        params.put("poolId", poolId);
        params.put("useILMPolicy", useILMPolicy);
        if (personPool != null && personPool.size() > 0) {
            params.put("personPool", personPool);
        }
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> addPersonPool(String poolId, int poolType, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("AddPersonPool", callBack);
        params.put("poolId", poolId);
        params.put("poolType", poolType);
        if (personPool != null && personPool.size() > 0) {
            params.put("personPool", personPool);
        }
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> delPersonPool(int flushPool, String poolId, List<Person> personIds, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("DelPersonPool", callBack);
        params.put("flushPool", flushPool);
        params.put("poolId", poolId);
        params.put("personIds", personIds);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> delPoolData(String poolId, Long mallId, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("DelPoolData", callBack);
        params.put("poolId", poolId);
        params.put("mallId", mallId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> delStaffPoolData(String poolId, List<String> fidList, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("DelStaffPoolData", callBack);
        params.put("poolId", poolId);
        params.put("fidList", fidList);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> queryPersonPool(int listAll, String poolId, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("QueryPersonPool", callBack);
        params.put("listAll", listAll);
        params.put("poolId", poolId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> modifyPersonPool(String poolId, int poolType, int updateType, List<Person> personPool, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (poolId == null || poolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPool == null || personPool.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPool\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("ModifyPersonPool", callBack);
        params.put("poolId", poolId);
        params.put("poolType", poolType);
        params.put("updateType", updateType);
        params.put("personPool", personPool);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> matchPerson(int personType, Person person, String personPoolId, List<Person> personPool, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPoolId == null || "".equals(personPoolId)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("MatchPerson", callBack);
        params.put("personType", personType);
        params.put("person", person);
        params.put("personPoolId", personPoolId);
        params.put("personPool", personPool);
        this.addOptions(params, options);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> countMatchPerson(Person person, String personPoolId, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPoolId == null || "".equals(personPoolId)) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("CountMatchPerson", callBack);
        params.put("person", person);
        params.put("personPoolId", personPoolId);
        this.addOptions(params, options);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> matchHistoryPerson(int personType, Person person, List<String> unionPersonPoolId, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (unionPersonPoolId == null || unionPersonPoolId.size() <= 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010unionPersonPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u6ca1\u6709\u6c60\u540d\u79f0");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("MatchPerson", callBack);
        params.put("personType", personType);
        params.put("person", person);
        params.put("unionPersonPoolId", unionPersonPoolId);
        this.addOptions(params, options);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    private void addOptions(Map<String, Object> params, Map<String, Object> options) {
        Object agg;
        if (options == null || options.size() == 0) {
            return;
        }
        Object size = options.get("size");
        if (size != null) {
            params.put("size", size);
        }
        if ((agg = options.get("agg")) != null) {
            params.put("agg", agg);
        }
    }

    public CompletableFuture<AlgResult> updatePerson(String poolId, int personType, Person person, FaceFeature newFaceFeature, Map<String, Object> options) throws ParameterExceptin, IOException, DeploymentException {
        return this.updatePerson(poolId, personType, person, newFaceFeature, options, false);
    }

    public CompletableFuture<AlgResult> updatePerson(String poolId, int personType, Person person, FaceFeature newFaceFeature, Map<String, Object> options, boolean useILMPolicy) throws ParameterExceptin, IOException, DeploymentException {
        if (poolId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("UpdatePerson", callBack);
        params.put("poolId", poolId);
        params.put("personType", personType);
        params.put("person", person);
        params.put("newFaceFeature", newFaceFeature);
        params.put("useILMPolicy", useILMPolicy);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> updateStaff(String poolId, Person person, Map<String, Object> options, boolean useILMPolicy) throws ParameterExceptin, IOException, DeploymentException {
        if (poolId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010poolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("UpdateStaff", callBack);
        params.put("poolId", poolId);
        params.put("person", person);
        params.put("useILMPolicy", useILMPolicy);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> verifyPerson(int personType, Person person, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (person == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010person\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("VerifyPerson", callBack);
        params.put("personType", personType);
        params.put("person", person);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> clusterPerson(int personType, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (personPoolId == null || personPoolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPool == null || personPool.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPool\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("ClusterPerson", callBack);
        params.put("personType", personType);
        params.put("personPoolId", personPoolId);
        params.put("personPool", personPool);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> verifyPersonPool(int personType, String personPoolId, List<Person> personPool, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (personPoolId == null || personPoolId == "") {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personPool == null || personPool.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010personPool\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("VerifyPersonPool", callBack);
        params.put("personType", personType);
        params.put("personPoolId", personPoolId);
        params.put("personPool", personPool);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getMotionTrack(List<Person> motionPoints, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        if (motionPoints == null || motionPoints.size() == 0) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010motionPoints\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetMotionTrack", callBack);
        params.put("motionPoints", motionPoints);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> addCaptureRecords(List<CaptureRecord> captureRecords, Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object calId = options.get("calId");
        if (calId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010calId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object clerkPoolId = options.get("clerkPoolId");
        if (clerkPoolId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010clerkPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object takeawayPersonPoolId = options.get("takeawayPersonPoolId");
        if (takeawayPersonPoolId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010takeawayPersonPoolId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("AddCaptureRecords", callBack);
        params.put("calId", calId);
        params.put("clerkPoolId", clerkPoolId);
        params.put("takeawayPersonPoolId", takeawayPersonPoolId);
        params.put("esIndex", options.get("esIndex"));
        if (captureRecords != null || captureRecords.size() > 0) {
            params.put("captureRecords", captureRecords);
        }
        this.httpOrWebSocketSend(callBack, params, TIME_OUT);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> queryCaptureRecords(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object calId = options.get("calId");
        if (calId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010calId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("QueryCaptureRecords", callBack);
        params.put("calId", calId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> deleteCaptureRecords(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object calId = options.get("calId");
        if (calId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010calId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("DeleteCaptureRecords", callBack);
        params.put("calId", calId);
        params.put("clearAll", 1);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> queryCalIds(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("QueryCalIds", callBack);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> analyzeRecords(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object calId = options.get("calId");
        if (calId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010calId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("AnalyzeRecords", callBack);
        params.put("calId", calId);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> analyzeRecords(Map<String, Object> options, Long timeout) throws IOException, DeploymentException, ParameterExceptin {
        Object calId = options.get("calId");
        Object shopBeginTime = options.get("shopBeginTime");
        Object shopEndTime = options.get("shopEndTime");
        Object isSmartClerk = options.get("isSmartClerk");
        Object projectModel = options.get("projectModel");
        Object clerkMatchScore = options.get("clerkMatchScore");
        Object clerkBodyMatchScore = options.get("clerkBodyMatchScore");
        Object personMatchScore = options.get("personMatchScore");
        Object personBodyMatchScore = options.get("personBodyMatchScore");
        Object customerMatchScore = options.get("customerMatchScore");
        Object customerBodyMatchScore = options.get("customerBodyMatchScore");
        Object analyzeReception = options.get("analyzeReception");
        Object calibrationPoints = options.get("calibrationPoints");
        Object analyzeType = options.get("analyzeType");
        Object converge = options.get("converge");
        Object analyzePersonBatch = options.get("analyzePersonBatch");
        Object personGroupInterval = options.get("personGroupInterval");
        Object personGroupAnalyzeType = options.get("personGroupAnalyzeType");
        Object spacingThreshold = options.get("spacingThreshold");
        Object receptionThreshold = options.get("receptionThreshold");
        Object personGroupSpacingThreshold = options.get("personGroupSpacingThreshold");
        Object personMatchScoreList = options.get("personMatchScoreList");
        if (calId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010calId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("AnalyzeRecords", callBack);
        params.put("calId", calId);
        params.put("shopBeginTime", shopBeginTime);
        params.put("shopEndTime", shopEndTime);
        params.put("isSmartClerk", isSmartClerk);
        params.put("projectModel", projectModel);
        params.put("clerkMatchScore", clerkMatchScore);
        params.put("clerkBodyMatchScore", clerkBodyMatchScore);
        params.put("personMatchScore", personMatchScore);
        params.put("personBodyMatchScore", personBodyMatchScore);
        params.put("customerMatchScore", customerMatchScore);
        params.put("customerBodyMatchScore", customerBodyMatchScore);
        params.put("analyzeReception", analyzeReception);
        params.put("calibrationPoints", calibrationPoints);
        params.put("converge", converge == null ? Integer.valueOf(1) : converge);
        params.put("analyzeType", analyzeType == null ? Integer.valueOf(0) : analyzeType);
        params.put("analyzePersonBatch", analyzePersonBatch == null ? Integer.valueOf(0) : analyzePersonBatch);
        params.put("personGroupInterval", personGroupInterval == null ? Integer.valueOf(10) : personGroupInterval);
        params.put("personGroupAnalyzeType", personGroupAnalyzeType == null ? Integer.valueOf(0) : personGroupAnalyzeType);
        params.put("spacingThreshold", spacingThreshold == null ? Double.valueOf(1.5) : spacingThreshold);
        params.put("receptionThreshold", receptionThreshold == null ? Integer.valueOf(3) : receptionThreshold);
        params.put("personGroupSpacingThreshold", personGroupSpacingThreshold == null ? Double.valueOf(1.5) : personGroupSpacingThreshold);
        params.put("personMatchScoreList", personMatchScoreList);
        log.info("\u8c03\u7528\u5206\u6790\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        this.httpOrWebSocketSend(callBack, params, TIME_OUT);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> GetOrderDetails(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object transactionId = options.get("transactionId");
        Object beginIndex = options.get("beginIndex");
        Object endIndex = options.get("endIndex");
        if (transactionId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010transactionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (beginIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010beginIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (endIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010endIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetOrderDetails", callBack);
        params.put("transactionId", transactionId);
        params.put("beginIndex", beginIndex);
        params.put("endIndex", endIndex);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getVerifiedPersonDetails(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object transactionId = options.get("transactionId");
        Object beginIndex = options.get("beginIndex");
        Object endIndex = options.get("endIndex");
        if (transactionId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010transactionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (beginIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010beginIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (endIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010endIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetVerifiedPersonDetails", callBack);
        params.put("transactionId", transactionId);
        params.put("beginIndex", beginIndex);
        params.put("endIndex", endIndex);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getStandardPersonDetails(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object transactionId = options.get("transactionId");
        Object beginIndex = options.get("beginIndex");
        Object endIndex = options.get("endIndex");
        if (transactionId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010transactionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (beginIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010beginIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (endIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010endIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetStandardPersonDetails", callBack);
        params.put("transactionId", transactionId);
        params.put("beginIndex", beginIndex);
        params.put("endIndex", endIndex);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> addStaffRecords(List<StaffRecord> staffRecords, Map<String, Object> options, Long timeout) throws IOException, DeploymentException, ParameterExceptin {
        Object calId = options.get("calId");
        if (calId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010calId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("AddStaffFeature", callBack);
        params.put("calId", calId);
        params.put("staffFeatures", staffRecords);
        this.httpOrWebSocketSend(callBack, params, TIME_OUT);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getAnalyzeStatus(Map<String, Object> options, Long timeout) throws IOException, DeploymentException, ParameterExceptin {
        Object calId = options.get("calId");
        if (calId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010calId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetAnalyzeStatus", callBack);
        params.put("calId", calId);
        this.httpOrWebSocketSend(callBack, params, TIME_OUT);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getReceptionDetails(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object transactionId = options.get("transactionId");
        Object beginIndex = options.get("beginIndex");
        Object endIndex = options.get("endIndex");
        if (transactionId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010transactionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (beginIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010beginIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (endIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010endIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetReceptionDetails", callBack);
        params.put("transactionId", transactionId);
        params.put("beginIndex", beginIndex);
        params.put("endIndex", endIndex);
        log.info("\u83b7\u53d6\u63a5\u5f85\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(params));
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    public CompletableFuture<AlgResult> getPersonBatchDetails(Map<String, Object> options) throws IOException, DeploymentException, ParameterExceptin {
        Object transactionId = options.get("transactionId");
        Object beginIndex = options.get("beginIndex");
        Object endIndex = options.get("endIndex");
        if (transactionId == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010transactionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (beginIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010beginIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (endIndex == null) {
            throw new ParameterExceptin("\u5b57\u6bb5\u3010endIndex\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompletableFuture<AlgResult> completableFuture = new CompletableFuture<AlgResult>();
        Consumer<AlgResult> callBack = completableFuture::complete;
        Map<String, Object> params = this.getParams("GetPersonBatchDetails", callBack);
        params.put("transactionId", transactionId);
        params.put("beginIndex", beginIndex);
        params.put("endIndex", endIndex);
        this.httpOrWebSocketSend(callBack, params);
        return completableFuture;
    }

    private void httpOrWebSocketSend(Consumer<AlgResult> callBack, Map<String, Object> params) throws IOException, DeploymentException {
        if (this.httpFlag.booleanValue()) {
            HashMap hashMap = (HashMap)params;
            this.httpUtil.send(this.urlInfo, hashMap, callBack);
        } else {
            this.wsClientFacetory.send(JSON.toJSONString(params));
        }
    }

    private void httpOrWebSocketSend(Consumer<AlgResult> callBack, Map<String, Object> params, Long timeout) throws IOException, DeploymentException {
        if (this.httpFlag.booleanValue()) {
            HashMap hashMap = (HashMap)params;
            this.httpUtil.send(this.urlInfo, hashMap, callBack, timeout);
        } else {
            this.wsClientFacetory.send(JSON.toJSONString(params), timeout);
        }
    }
}

