package com.viontech.keliu.websocket;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;

public class WsClientFacetory {

    private String urL = null;
    private URI uri;
    private Session session;
    private WebSocketContainer container;
    private Logger logger = LoggerFactory.getLogger(WsClientFacetory.class);

    public void setUrl(String urL) {
        this.urL = urL;
    }

    public synchronized void send(String text) throws IOException, DeploymentException {
        if (text == null || "".equals(text)) {
            return;
        }
        try {
            Session session = createConnect();
            session.getBasicRemote().sendText(text);
//			logger.info("发送消息 {} 成功",text);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("发送消息失败:", e);
        }
//		logger.info("发送消息 {} 失败",text);
    }

    public synchronized void send(String text, long timeout) throws IOException, DeploymentException {
        if (text == null || "".equals(text)) {
            return;
        }
        try {
            Session session = getSession(timeout);
            session.getBasicRemote().sendText(text);
//			logger.info("发送消息 {} 成功",text);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("发送消息失败:", e);
        }
//		logger.info("发送消息 {} 失败",text);
    }

    private Session createConnect() throws DeploymentException, IOException {
        return getSession();
    }

    private URI getUri() {
        if (uri == null)
            uri = URI.create(urL);
        return uri;
    }

    private synchronized Session getSession() throws DeploymentException, IOException {
        return getSession(3000);
//        if (session == null || !session.isOpen()) {
//            if (session != null && !session.isOpen()) {
//                session.close();
//            }
//            session = getContainer().connectToServer(WsClient.class, getUri());
//            session.setMaxTextMessageBufferSize(1000 * 1024);
//            session.setMaxIdleTimeout();
//        }
//
//        return session;
    }

    private synchronized Session getSession(long timeout) throws DeploymentException, IOException {
        if (session == null || !session.isOpen()) {
            if (session != null && !session.isOpen()) {
                session.close();
            }
            session = getContainer().connectToServer(WsClient.class, getUri());
            session.setMaxTextMessageBufferSize(1000 * 1024);
        }
        session.setMaxIdleTimeout(timeout);
        return session;
    }

    private WebSocketContainer getContainer() {
        if (container == null)
            container = ContainerProvider.getWebSocketContainer();
        return container;
    }

}
